/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.criteria;

import de.justsoftware.onx.searchnew.business.criteria.Criterion;

public class RangeExpression<T>
implements Criterion {
    private final T _minValue;
    private final T _maxValue;
    private final String _fieldName;

    public RangeExpression(String fieldName, T minValue, T maxValue) {
        if (minValue == null || maxValue == null) {
            throw new IllegalArgumentException("The values for a range expression must not be null!");
        }
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("The field name must not be null or empty");
        }
        this._fieldName = fieldName;
        this._minValue = minValue;
        this._maxValue = maxValue;
    }

    @Override
    public String toSolrQuery() {
        StringBuffer result = new StringBuffer();
        result.append(this._fieldName).append(":[").append(this._minValue).append(" TO ").append(this._maxValue).append("]");
        return result.toString();
    }
}

