/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.criteria;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.criteria.SolrQueryElement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class LocalParamCriterion
implements Criterion {
    private static final Joiner PARAMS_JOINER = Joiner.on((char)' ').skipNulls();
    private final String _criterion;
    private final List<LocalParam> _localParams = new ArrayList<LocalParam>();
    private final boolean _inlineValueParameter;

    public LocalParamCriterion(@Nonnull LocalParam localParam, @Nonnull Criterion criterion, boolean inlineValueParameter) {
        this._criterion = criterion.toSolrQuery();
        this._localParams.add(localParam);
        this._inlineValueParameter = inlineValueParameter;
    }

    public LocalParamCriterion(@Nonnull String localParamValue, @Nonnull String criterion, boolean inlineValueParameter) {
        this._criterion = criterion;
        this._localParams.add(new LocalParam(localParamValue));
        this._inlineValueParameter = inlineValueParameter;
    }

    public void addLocalParam(@Nonnull LocalParam localParam) {
        this._localParams.add(localParam);
    }

    @Override
    public String toSolrQuery() {
        StringBuilder sb = new StringBuilder();
        if (!this._localParams.isEmpty() || this._inlineValueParameter) {
            sb.append("{!");
            PARAMS_JOINER.appendTo(sb, Iterables.transform(this._localParams, SolrQueryElement.TO_SOLR_QUERY));
            if (this._inlineValueParameter) {
                sb.append(" v=").append(this._criterion);
            }
            sb.append("}");
        }
        if (!this._inlineValueParameter) {
            sb.append(this._criterion);
        }
        return sb.toString();
    }
}

