/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.criteria;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.justsoftware.onx.searchnew.business.criteria.AbstractCriteria;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.criteria.SolrQueryElement;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilterQueryCriteria
extends AbstractCriteria {
    private static final Joiner PARAMS_JOINER = Joiner.on((char)' ').skipNulls();
    private static final String QUERY_OPERATOR = "q.op";
    private static final ImmutableSet<LocalParam> DEFAULT_OPERATOR_PARAM = ImmutableSet.of((Object)new LocalParam("q.op", "AND"));
    private final Collection<LocalParam> _localParams = Lists.newArrayList();

    public FilterQueryCriteria() {
        this((Criterion)null);
    }

    public FilterQueryCriteria(@Nullable Criterion criterion) {
        super("fq", criterion);
    }

    public void addLocalParam(@Nonnull LocalParam param) {
        this._localParams.add(param);
    }

    @Override
    public String toSolrQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("{!");
        sb.append(FluentIterable.from(this._localParams).append(this.getDefaultOperatorIfNeeded()).transform(SolrQueryElement.TO_SOLR_QUERY).join(PARAMS_JOINER));
        sb.append("}");
        sb.append(super.toSolrQuery());
        return sb.toString();
    }

    @Nonnull
    private ImmutableSet<LocalParam> getDefaultOperatorIfNeeded() {
        return this.isDefaultOperatorDefined() ? ImmutableSet.of() : DEFAULT_OPERATOR_PARAM;
    }

    private boolean isDefaultOperatorDefined() {
        for (LocalParam localParam : this._localParams) {
            if (!QUERY_OPERATOR.equals(localParam.getKey())) continue;
            return true;
        }
        return false;
    }
}

