/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business;

import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributesUtil;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.server.model.DynamicEntityAttributeSearchFieldModel;
import de.justsoftware.onx.searchnew.shared.server.model.DynamicSearchFieldModel;
import de.justsoftware.onx.searchnew.shared.server.model.MultiWikiSearchFieldModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum SearchFieldUtil {
    INSTANCE;


    @CheckForNull
    public static SearchField getSearchFieldByName(@Nullable String fieldName, final @Nonnull FilterType filterType) {
        return SearchFieldUtil.getSearchFieldByName(fieldName, new EntityDynamicAttributeResolver(){

            @Override
            public DynamicEntityAttributeSearchFieldModel resolveToEntityAttributeSearchFieldModel(String searchFieldName) {
                EntityType type;
                if (FilterType.IS_ENTITY_TYPE.apply((Object)filterType) && EntityDynamicAttributesUtil.isEntityDynamicAttributeForType(searchFieldName, type = ((EntityFilterType)filterType).getType())) {
                    return new DynamicEntityAttributeSearchFieldModel(EntityDynamicAttributesUtil.getAttributeIdFromFieldName(searchFieldName, type), type);
                }
                return null;
            }
        });
    }

    @CheckForNull
    public static SearchField getSearchFieldByName(@Nullable String fieldName, final @Nonnull ImmutableSetMultimap<EntityType, DynamicAttributeConfig> searchableEntityDynAttributes) {
        return SearchFieldUtil.getSearchFieldByName(fieldName, new EntityDynamicAttributeResolver(){

            @Override
            public DynamicEntityAttributeSearchFieldModel resolveToEntityAttributeSearchFieldModel(String searchFieldName) {
                for (EntityType entityType : searchableEntityDynAttributes.keySet()) {
                    if (!EntityDynamicAttributesUtil.isEntityDynamicAttributeForType(searchFieldName, entityType)) continue;
                    return new DynamicEntityAttributeSearchFieldModel(EntityDynamicAttributesUtil.getAttributeIdFromFieldName(searchFieldName, entityType), entityType);
                }
                return null;
            }
        });
    }

    @CheckForNull
    private static SearchField getSearchFieldByName(@Nullable String fieldName, @Nonnull EntityDynamicAttributeResolver entityDynamciAttributeResolver) {
        DynamicEntityAttributeSearchFieldModel entityAttributeSearchFieldModel;
        if (fieldName == null) {
            return null;
        }
        if (fieldName.startsWith("profile_dynamic_")) {
            return new DynamicSearchFieldModel(fieldName.substring("profile_dynamic_".length()));
        }
        if (EntityDynamicAttributesUtil.isEntityDynamicAttribute(fieldName) && (entityAttributeSearchFieldModel = entityDynamciAttributeResolver.resolveToEntityAttributeSearchFieldModel(fieldName)) != null) {
            return entityAttributeSearchFieldModel;
        }
        if (fieldName.startsWith("multiwiki_for_role_")) {
            return new MultiWikiSearchFieldModel(fieldName);
        }
        for (CommonSearchFields field : CommonSearchFields.values()) {
            if (!fieldName.equalsIgnoreCase(field.getFieldName())) continue;
            return field;
        }
        return null;
    }

    private static interface EntityDynamicAttributeResolver {
        @CheckForNull
        public DynamicEntityAttributeSearchFieldModel resolveToEntityAttributeSearchFieldModel(@Nullable String var1);
    }
}

