/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.model.db.DBDocument;
import de.justsoftware.onx.document.shared.model.db.DBDocumentVersion;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public abstract class AdditionalSuggestData<T> {
    private final Map<CompoundId, T> _dbBeans;

    protected AdditionalSuggestData(@Nonnull Map<CompoundId, T> dbBeans) {
        this._dbBeans = dbBeans;
    }

    @Nonnull
    public final Map<CompoundId, T> getDBBeans() {
        return this._dbBeans;
    }

    public static class AdditionalWorkstreamSuggestData
    extends AdditionalSuggestData<DBWorkstreamMessage> {
        public static final AdditionalWorkstreamSuggestData EMPTY = new AdditionalWorkstreamSuggestData((Map<CompoundId, DBWorkstreamMessage>)ImmutableMap.of(), (Map<WorkstreamMessageId, WorkstreamMessage>)ImmutableMap.of());
        private final Map<WorkstreamMessageId, WorkstreamMessage> _workstreamMessages;

        public AdditionalWorkstreamSuggestData(@Nonnull Map<CompoundId, DBWorkstreamMessage> dbBeans, @Nonnull Map<WorkstreamMessageId, WorkstreamMessage> workstreamMessages) {
            super(dbBeans);
            this._workstreamMessages = workstreamMessages;
        }

        @Nonnull
        public Map<WorkstreamMessageId, WorkstreamMessage> getWorkstreamMessages() {
            return this._workstreamMessages;
        }
    }

    @ParametersAreNonnullByDefault
    public static class PersonAdditionalSuggestData
    extends AdditionalSuggestData<DBPerson> {
        public static final PersonAdditionalSuggestData EMPTY = new PersonAdditionalSuggestData((Map<CompoundId, DBPerson>)ImmutableMap.of(), (ImmutableListMultimap<PersonId, BadgeField>)ImmutableListMultimap.of());
        private final ImmutableListMultimap<PersonId, BadgeField> _visibleFields;

        public PersonAdditionalSuggestData(Map<CompoundId, DBPerson> dbBeans, ImmutableListMultimap<PersonId, BadgeField> visibleFields) {
            super(dbBeans);
            this._visibleFields = visibleFields;
        }

        @Nonnull
        public ImmutableListMultimap<PersonId, BadgeField> getVisibleFields() {
            return this._visibleFields;
        }
    }

    @ParametersAreNonnullByDefault
    public static class AdditionalEntitySuggestData
    extends AdditionalSuggestData<DBEntity> {
        public static final AdditionalEntitySuggestData EMPTY = new AdditionalEntitySuggestData((Map<CompoundId, DBEntity>)ImmutableMap.of(), (ImmutableMap<EntityId, EntityInfo>)ImmutableMap.of());
        private final ImmutableMap<EntityId, EntityInfo> _parentInfos;

        public AdditionalEntitySuggestData(Map<CompoundId, DBEntity> dbBeans, ImmutableMap<EntityId, EntityInfo> parentInfos) {
            super(dbBeans);
            this._parentInfos = parentInfos;
        }

        @Nonnull
        public ImmutableMap<EntityId, EntityInfo> getParentInfos() {
            return this._parentInfos;
        }
    }

    public static class AdditionalDocumentSuggestData
    extends AdditionalSuggestData<DBDocument> {
        public static final AdditionalDocumentSuggestData EMPTY = new AdditionalDocumentSuggestData((Map<CompoundId, DBDocument>)ImmutableMap.of(), (Map<DocumentId, DBDocumentVersion>)ImmutableMap.of(), (ImmutableMap<ItemId, WorkstreamMessageId>)ImmutableMap.of());
        private final Map<DocumentId, DBDocumentVersion> _dbVersions;
        private final ImmutableMap<ItemId, WorkstreamMessageId> _parentWorkstreamMessages;

        public AdditionalDocumentSuggestData(@Nonnull Map<CompoundId, DBDocument> dbBeans, @Nonnull Map<DocumentId, DBDocumentVersion> dbDocumentVersions, @Nonnull ImmutableMap<ItemId, WorkstreamMessageId> parentWorkstreamMessages) {
            super(dbBeans);
            this._dbVersions = dbDocumentVersions;
            this._parentWorkstreamMessages = parentWorkstreamMessages;
        }

        @Nonnull
        public Map<DocumentId, DBDocumentVersion> getDbVersions() {
            return this._dbVersions;
        }

        @Nonnull
        public ImmutableMap<ItemId, WorkstreamMessageId> getParentWorkstreamMessages() {
            return this._parentWorkstreamMessages;
        }
    }
}

