/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.rest.business;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.notificationclient.model.NotificationMail;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.mail.business.NotificationMailService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/rest/internal/notification"})
public class NotificationMailController {
    private final NotificationMailService _notificationMailService;
    private final PersonService _personService;

    @Autowired
    public NotificationMailController(NotificationMailService notificationMailService, PersonService personService) {
        this._notificationMailService = notificationMailService;
        this._personService = personService;
    }

    @RequestMapping(value={"/mail"}, method={RequestMethod.POST})
    public void notificationMail(@RequestBody List<NotificationMail> notificationsMails) {
        Set<PersonId> receiverIds = notificationsMails.stream().map(summary -> PersonId.parse(summary.getReceiverId())).filter(Objects::nonNull).collect(Collectors.toSet());
        ImmutableMap<PersonId, DBPerson> receiverList = this._personService.getPersonsByIds(receiverIds);
        notificationsMails.forEach(notificationMail -> {
            PersonId receiverId = PersonId.parse(notificationMail.getReceiverId());
            if (receiverId != null && receiverList.containsKey(receiverId)) {
                this._notificationMailService.sendNotificationEmail((NotificationMail)notificationMail, (DBPerson)receiverList.get(receiverId));
            }
        });
    }
}

