/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.cache.AbstractRelationalCacheAccessor;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.util.BeanUtil;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.events.RawEditorVersionCreatedEvent;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.integration.persistence.RawEditorDAO;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersionId;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import de.justsoftware.onx.raweditor.shared.server.model.RawEditorItem;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class RawEditorServiceImpl
implements RawEditorService {
    private static final ImmutableSet<? extends Action> RAWEDITOR_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.RAWEDITOR_READ, (Object)StaticAction.RAWEDITOR_WRITE);
    private final RawEditorDAO _rawEditorDAO;
    private final JCEventBus _eventBus;
    private final CurrentRawEditorCacheAccessor _currentRawEditorCacheAccessor;

    @Autowired
    public RawEditorServiceImpl(RawEditorDAO rawEditorDAO, MemcachedClientCache cache, JCEventBus eventBus) {
        this._rawEditorDAO = rawEditorDAO;
        this._eventBus = eventBus;
        this._currentRawEditorCacheAccessor = new CurrentRawEditorCacheAccessor(cache, rawEditorDAO);
    }

    @Override
    public DBRawEditorVersion getCurrentDBVersionByParentId(GlobalId parentId, ComponentType editorType) {
        return (DBRawEditorVersion)this._currentRawEditorCacheAccessor.getSingle(parentId, editorType);
    }

    @Override
    public ImmutableTable<GlobalId, ComponentType, DBRawEditorVersion> getCurrentDBVersionsByParents(SetMultimap<? extends GlobalId, ? extends ComponentType> parentsAndComponents) {
        return this._currentRawEditorCacheAccessor.getTable(parentsAndComponents);
    }

    @Override
    public RawEditorVersion getCurrentVersionByParentId(GlobalId parentId, ComponentType editorType, AuthorizationCheckContext authorizationContext) {
        DBRawEditorVersion dbRawEditorVersion = this.getCurrentDBVersionByParentId(parentId, editorType);
        if (dbRawEditorVersion == null) {
            return null;
        }
        RawEditorVersion rawEditorVersion = BeanUtil.createBeanFromChildBean(RawEditorVersion.class, dbRawEditorVersion);
        rawEditorVersion.setMay(authorizationContext.may(new RawEditorItem(dbRawEditorVersion), RAWEDITOR_CHECK_ACTIONS));
        return rawEditorVersion;
    }

    @Override
    public RawEditorVersionId insertVersion(DBRawEditorVersion version) {
        RawEditorVersionId id = this._rawEditorDAO.insertVersion(version);
        this._currentRawEditorCacheAccessor.invalidateKey(version.getParentId(), version.getEditorType());
        this._eventBus.post(new RawEditorVersionCreatedEvent(version.getParentId(), version.getEditorType(), true));
        return id;
    }

    @Override
    public RawEditorId insertFirstVersion(DBRawEditorVersion version, ServerEventCollector eventCollector) {
        RawEditorId rawEditorId = this._rawEditorDAO.insertFirstVersion(version);
        this._currentRawEditorCacheAccessor.invalidateKey(version.getParentId(), version.getEditorType());
        eventCollector.add(new RawEditorVersionCreatedEvent(version.getParentId(), version.getEditorType(), false));
        return rawEditorId;
    }

    @Override
    public ImmutableMap<RawEditorId, DBRawEditorVersion> getCurrentVersionsByIds(Set<RawEditorId> ids) {
        return this._rawEditorDAO.getCurrentVersionsByIds(ids);
    }

    @Override
    public ImmutableSet<RawEditorId> getRawEditorIdsByParentId(GlobalId parentId) {
        return ImmutableSet.copyOf(this._rawEditorDAO.getEditorIdsByParentId(parentId));
    }

    @Override
    public void deleteDependentRawEditors(Iterable<RawEditorId> editorIds, GlobalId parentId, DeletionContext deletionContext) {
        ImmutableSet<ComponentType> componentTypes = this._rawEditorDAO.getEditorTypesByEditorIds(editorIds);
        final ImmutableSet entries = ImmutableSetMultimap.builder().putAll((Object)parentId, componentTypes).build().entries();
        deletionContext.attach(new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                RawEditorServiceImpl.this._currentRawEditorCacheAccessor.invalidateKeys(entries);
            }
        });
        this._rawEditorDAO.deleteVersionsByEditorIds(editorIds);
    }

    private static enum RawEditorServiceServiceCacheName implements CacheName
    {
        CURRENT_VERSION("RawEditor_currentVersion");

        private final String _cacheName;

        private RawEditorServiceServiceCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class CurrentRawEditorCacheAccessor
    extends AbstractRelationalCacheAccessor<CacheName, GlobalId, ComponentType, DBRawEditorVersion> {
        private final RawEditorDAO _rawEditorDAO;

        private CurrentRawEditorCacheAccessor(CacheClient<? super CacheName> cache, RawEditorDAO rawEditorDAO) {
            super(cache, RawEditorServiceServiceCacheName.CURRENT_VERSION);
            this._rawEditorDAO = rawEditorDAO;
        }

        @Override
        protected String keyToString(GlobalId left, ComponentType right) {
            return left + "," + right;
        }

        @Override
        protected Table<? extends GlobalId, ? extends ComponentType, ? extends DBRawEditorVersion> getFromDatabase(ImmutableSetMultimap<GlobalId, ComponentType> param) {
            return this._rawEditorDAO.getCurrentVersionsByParentIds((SetMultimap<? extends GlobalId, ? extends ComponentType>)param);
        }
    }
}

