/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.util;

import de.justsoftware.onx.push.model.PushNotificationType;
import de.justsoftware.pushnotification.client.model.ApnsPushNotification;
import de.justsoftware.pushnotification.client.model.PushNotificationApp;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ApnsPushNotifications {
    private ApnsPushNotifications() {
    }

    @Nonnull
    public static ApnsPushNotification pushNotification(String token, PushNotificationApp app, PushNotificationType notificationType, String title, String body, int badgeNumber, @Nullable Map<String, String> customProperties) {
        return ApnsPushNotifications.pushNotification(token, app, notificationType, title, null, body, badgeNumber, null, null, false, customProperties);
    }

    @Nonnull
    public static ApnsPushNotification pushNotification(String token, PushNotificationApp app, PushNotificationType notificationType, String title, @Nullable String subtitle, String body, int badgeNumber, @Nullable String threadId, @Nullable String category, boolean contentAvailable, @Nullable Map<String, String> customProperties) {
        return new ApnsPushNotification(UUID.randomUUID(), token, app, notificationType.name(), title, subtitle, body, Integer.valueOf(badgeNumber), threadId, category, contentAvailable, true, ApnsPushNotifications.customSoundFile(app), customProperties);
    }

    @CheckForNull
    private static String customSoundFile(PushNotificationApp app) {
        switch (app) {
            case MOBILE_NG_WRAPPER: {
                return null;
            }
            case CHAT: {
                return "Push Connect.wav";
            }
            case MOBILE_NG_NATIVE_WRAPPER: {
                return "Push Social.wav";
            }
        }
        return null;
    }

    @Nonnull
    public static ApnsPushNotification silentSync(String token, PushNotificationApp app, PushNotificationType notificationType) {
        return ApnsPushNotifications.silentSync(token, app, notificationType.name(), null);
    }

    @Nonnull
    public static ApnsPushNotification silentSync(String token, PushNotificationApp app, PushNotificationType notificationType, @Nullable Map<String, String> customProperties) {
        return ApnsPushNotifications.silentSync(token, app, notificationType.name(), customProperties);
    }

    @Nonnull
    public static ApnsPushNotification toSilentSync(ApnsPushNotification pushNotification) {
        return ApnsPushNotifications.silentSync(pushNotification.getToken(), pushNotification.getApp(), pushNotification.getType(), (Map<String, String>)pushNotification.getCustomProperties());
    }

    @Nonnull
    private static ApnsPushNotification silentSync(String token, PushNotificationApp app, String notificationType, @Nullable Map<String, String> customProperties) {
        return new ApnsPushNotification(UUID.randomUUID(), token, app, notificationType, null, null, null, null, null, null, true, false, null, customProperties);
    }
}

