/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.push.integration.persistence.PushNotificationDAO;
import de.justsoftware.onx.push.integration.persistence.ibatis.DBPushTargetApp;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
public class IbatisPushNotificationDAO
implements PushNotificationDAO {
    private static final String NAMESPACE = "PushNotification.";
    private final SqlMapClient _sqlMapClient;
    private final TransactionHelper _transactionHelper;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisPushNotificationDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient, TransactionHelper transactionHelper) {
        this._sqlMapClient = sqlMapClient;
        this._transactionHelper = transactionHelper;
    }

    @Override
    public PushRegistrationId insertPushTargetApp(PushTargetApp app, PersonId personId) {
        return (PushRegistrationId)this._transactionHelper.doInTransaction(status -> {
            this.removePushTargetAppsByReceivers((Iterable<PushTargetApp.Receiver>)ImmutableSet.of((Object)app.getReceiver()));
            PushRegistrationId id = (PushRegistrationId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "PushNotification.nextPushTargetAppId");
            IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "PushNotification.insertPushTargetApp", new DBPushTargetApp(id, app, personId));
            return id;
        });
    }

    @Override
    public boolean updatePushTargetApp(PushRegistrationId id, PushTargetApp app, PersonId personId) {
        return IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "PushNotification.updatePushTargetApp", new DBPushTargetApp(id, app, personId)) > 0;
    }

    @Override
    public boolean removePushTargetApp(PushRegistrationId id, PersonId personId) {
        return IbatisDAOUtil.wrappedDelete(this._sqlMapClient, "PushNotification.removePushTargetAppByRegistrationId", ImmutableMap.of((Object)"id", (Object)id, (Object)"personId", (Object)personId)) > 0;
    }

    @Override
    public ImmutableMultimap<PersonId, DBPushTargetApp> getPushTargetAppsByPersonIds(Set<PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMultimap(this._sqlMapClient, "PushNotification.getPushTargetAppsByPersonIds", "personId", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void removePushTargetAppsByPersonIds(Set<PersonId> personIds) {
        if (!CollectionUtil.isEmpty(personIds)) {
            IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapClient, "PushNotification.removePushTargetAppsByPersonIds", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        }
    }

    @Override
    public void removePushTargetAppsByReceivers(final Iterable<PushTargetApp.Receiver> receivers) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisDAOUtil.wrappedPartitionDelete(IbatisPushNotificationDAO.this._sqlMapClient, "PushNotification.removePushTargetAppsByReceivers", ImmutableSet.copyOf((Iterable)receivers), IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
            }
        });
    }
}

