/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.integration.persistence.ibatis;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.push.shared.model.PushAppName;
import de.justsoftware.onx.push.shared.model.PushNotificationProtocol;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DBPushTargetApp {
    private PushRegistrationId _id;
    private PersonId _personId;
    private PushAppName _appName;
    private String _token;
    private PushNotificationProtocol _protocol;
    private Date _createAt;
    private Date _modifyAt;

    @Deprecated
    protected DBPushTargetApp() {
    }

    public DBPushTargetApp(PushRegistrationId id, PushTargetApp app, PersonId personId) {
        this._id = id;
        this._appName = app.getAppName();
        this._token = app.getToken();
        this._protocol = app.getProtocol();
        this._personId = personId;
        this._createAt = new Date();
        this._modifyAt = new Date();
    }

    @Nonnull
    public PushTargetApp toApp() {
        return new PushTargetApp(this._id, this._appName, this._token, this._protocol);
    }

    @Nonnull
    public PushRegistrationId getId() {
        return this._id;
    }

    public void setId(PushRegistrationId id) {
        this._id = id;
    }

    @Nonnull
    public PushAppName getAppName() {
        return this._appName;
    }

    public void setAppName(PushAppName appName) {
        this._appName = appName;
    }

    @Nonnull
    public String getToken() {
        return this._token;
    }

    public void setToken(String token) {
        this._token = token;
    }

    @Nonnull
    public PushNotificationProtocol getProtocol() {
        return this._protocol;
    }

    public void setProtocol(PushNotificationProtocol protocol) {
        this._protocol = protocol;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    public void setPersonId(PersonId personId) {
        this._personId = personId;
    }

    @Nonnull
    public Date getCreateAt() {
        return Dates.clone(this._createAt);
    }

    public void setCreateAt(Date createAt) {
        this._createAt = Dates.clone(createAt);
    }

    @Nonnull
    public Date getModifyAt() {
        return Dates.clone(this._modifyAt);
    }

    public void setModifyAt(Date modifyAt) {
        this._modifyAt = Dates.clone(modifyAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("appName", (Object)this._appName).add("token", (Object)this._token).add("protocol", (Object)this._protocol).add("personId", (Object)this._personId).add("createAt", (Object)this._createAt).add("modifyAt", (Object)this._modifyAt).toString();
    }
}

