/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business.model;

import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PushNotificationQueueEntry<T> {
    private final UUID _id;
    private final T _pushNotification;
    private final Instant _entryTime;
    private final int _retryCount;
    private final Instant _nextRetry;

    public PushNotificationQueueEntry(T pushNotification, Instant entryTime) {
        this(UUID.randomUUID(), pushNotification, entryTime, 0, entryTime);
    }

    private PushNotificationQueueEntry(UUID id, T pushNotification, Instant entryTime, int retryCount, Instant nextRetry) {
        this._id = id;
        this._pushNotification = pushNotification;
        this._entryTime = entryTime;
        this._retryCount = retryCount;
        this._nextRetry = nextRetry;
    }

    @Nonnull
    public UUID getId() {
        return this._id;
    }

    @Nonnull
    public T getPushNotification() {
        return this._pushNotification;
    }

    @Nonnull
    public Instant getEntryTime() {
        return this._entryTime;
    }

    public int getRetryCount() {
        return this._retryCount;
    }

    @Nonnull
    public Instant getNextRetry() {
        return this._nextRetry;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("entryTime", (Object)this._entryTime).add("retryCount", this._retryCount).add("nextRetry", (Object)this._nextRetry).add("pushNotification", this._pushNotification).toString();
    }

    @Nonnull
    public Builder<T> buildUpon() {
        return new Builder(this);
    }

    @ParametersAreNonnullByDefault
    public static class Builder<T> {
        private final PushNotificationQueueEntry<T> _original;
        private int _retryCount;
        private Instant _nextRetry;

        Builder(PushNotificationQueueEntry<T> entry) {
            this._original = entry;
            this._retryCount = entry.getRetryCount();
            this._nextRetry = entry.getNextRetry();
        }

        @Nonnull
        public Builder<T> increaseRetryCount() {
            ++this._retryCount;
            return this;
        }

        @Nonnull
        public Builder<T> addToNextRetry(long durationMs) {
            this._nextRetry = this._nextRetry.plusMillis(durationMs);
            return this;
        }

        @Nonnull
        public PushNotificationQueueEntry<T> build() {
            return new PushNotificationQueueEntry<T>(this._original.getId(), this._original.getPushNotification(), this._original.getEntryTime(), this._retryCount, this._nextRetry);
        }
    }
}

