/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business;

import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.onx.notificationpush.business.NotificationPushFactory;
import de.justsoftware.onx.push.business.ApnsPushNotificationQueueService;
import de.justsoftware.onx.push.business.FcmPushNotificationQueueService;
import de.justsoftware.onx.push.model.PushNotifications;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PushNotificationSendService {
    private final ApnsPushNotificationQueueService _apnsPushNotificationQueueService;
    private final FcmPushNotificationQueueService _fcmPushNotificationQueueService;
    private final NotificationPushFactory _notificationPushFactory;

    @Autowired
    public PushNotificationSendService(ApnsPushNotificationQueueService apnsPushNotificationQueueService, FcmPushNotificationQueueService fcmPushNotificationQueueService, NotificationPushFactory notificationPushFactory) {
        this._apnsPushNotificationQueueService = apnsPushNotificationQueueService;
        this._fcmPushNotificationQueueService = fcmPushNotificationQueueService;
        this._notificationPushFactory = notificationPushFactory;
    }

    public void sendNotificationsPushNotification(PushNotification pushNotification) {
        if (pushNotification.getReceivers().isEmpty()) {
            return;
        }
        PushNotifications pushNotifications = this._notificationPushFactory.createPushNotifications(pushNotification);
        this._apnsPushNotificationQueueService.add(pushNotifications.getApnsPushNotifications());
        this._fcmPushNotificationQueueService.add(pushNotifications.getFcmPushNotifications());
    }
}

