/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business;

import javax.annotation.Nonnull;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class PushNotificationConfiguration {
    @Bean
    @Nonnull
    public RestTemplate junoRestTemplate(@Value(value="${juco.notification.connectionTimeoutMillis:60000}") int connectionTimeoutMillis) {
        return new RestTemplate(this.clientHttpRequestFactory(connectionTimeoutMillis));
    }

    @Nonnull
    private ClientHttpRequestFactory clientHttpRequestFactory(int connectionTimeoutMillis) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient());
        requestFactory.setBufferRequestBody(false);
        requestFactory.setReadTimeout(connectionTimeoutMillis);
        requestFactory.setConnectTimeout(connectionTimeoutMillis);
        return requestFactory;
    }

    @Nonnull
    private HttpClient httpClient() {
        return HttpClientBuilder.create().useSystemProperties().setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE).setConnectionManager(this.httpClientConnectionManager()).build();
    }

    @Nonnull
    private HttpClientConnectionManager httpClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(1);
        connectionManager.setValidateAfterInactivity(1000);
        return connectionManager;
    }
}

