/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.push.business;

import de.justsoftware.onx.push.business.AbstractPushNotificationQueueService;
import de.justsoftware.onx.push.business.JunoApnsRestClient;
import de.justsoftware.onx.push.business.PushNotificationWriteDataService;
import de.justsoftware.onx.push.business.model.PushNotificationQueueEntry;
import de.justsoftware.onx.push.shared.model.PushNotificationProtocol;
import de.justsoftware.pushnotification.client.model.ApnsPushNotification;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.time.Clock;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="apnsPushNotificationQueueService")
@ParametersAreNonnullByDefault
public class ApnsPushNotificationQueueService
extends AbstractPushNotificationQueueService<ApnsPushNotification> {
    private final JunoApnsRestClient _junoRestClient;

    @Autowired
    public ApnsPushNotificationQueueService(JunoApnsRestClient junoRestClient, PushNotificationWriteDataService pushNotificationWriteDataService, Clock clock, @Value(value="${juco.notification.apns.batchSize:50}") long batchSize, @Value(value="${juco.notification.maxLifetimeSeconds:7200}") int maxLifetimeSeconds, @Value(value="${juco.notification.retryInitialIntervalSeconds:30}") int retryInitialIntervalSeconds, @Value(value="${juco.notification.retryBackoffMultiplier:2}") double retryBackoffMultiplier) {
        super(pushNotificationWriteDataService, clock, batchSize, maxLifetimeSeconds, retryInitialIntervalSeconds, retryBackoffMultiplier, PushNotificationProtocol.APNS);
        this._junoRestClient = junoRestClient;
    }

    @Override
    protected PushNotificationResults sendPushNotifications(List<ApnsPushNotification> pushNotifications) {
        return this._junoRestClient.send(pushNotifications);
    }

    @Override
    protected String token(PushNotificationQueueEntry<ApnsPushNotification> queueEntry) {
        return queueEntry.getPushNotification().getToken();
    }

    @Override
    protected UUID pushNotificationId(PushNotificationQueueEntry<ApnsPushNotification> queueEntry) {
        return queueEntry.getPushNotification().getId();
    }
}

