/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum ProfileAttributeSearchType {
    SEARCH,
    OFF,
    FACET;


    public static boolean isSearchable(@Nullable ProfileAttributeSearchType searchable) {
        return searchable != null && !OFF.equals((Object)searchable);
    }

    public static boolean isSearchable(@Nullable ProfileAttributeConfiguration configuration) {
        return configuration != null && ProfileAttributeSearchType.isSearchable(configuration.getSearchable());
    }

    public static boolean isFacetable(@Nullable ProfileAttributeConfiguration configuration) {
        return configuration != null && FACET.equals((Object)configuration.getSearchable());
    }

    @CheckForNull
    public static ProfileAttributeSearchType offToNull(@Nullable ProfileAttributeSearchType searchable) {
        return OFF.equals((Object)searchable) ? null : searchable;
    }
}

