/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributePeriod;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributeBlock {
    public static final Function<ProfileAttributeBlock, Iterable<ProfileAttribute>> ATTRIBUTES = new NullPermeableFunction<ProfileAttributeBlock, Iterable<ProfileAttribute>>(){

        @Override
        protected Iterable<ProfileAttribute> applySafe(ProfileAttributeBlock input) {
            return input.getAttributes();
        }
    };
    private final Integer _orderIndex;
    private final ImmutableList<ProfileAttribute> _attributes;

    @JsonCreator
    public ProfileAttributeBlock(@JsonProperty(value="orderIndex", required=false) @Nullable Integer orderIndex, @JsonProperty(value="attributes", required=true) ImmutableList<ProfileAttribute> attributes) {
        this._orderIndex = orderIndex;
        this._attributes = attributes;
    }

    @CheckForNull
    public Integer getOrderIndex() {
        return this._orderIndex;
    }

    @Nonnull
    public ImmutableList<ProfileAttribute> getAttributes() {
        return this._attributes;
    }

    @JsonIgnore
    @CheckForNull
    public ProfileAttributePeriod getFirstPeriod() {
        ProfileAttribute attribute = this.findFirstAttributeOfType(ProfileAttributeType.MONTH_YEAR_PERIOD);
        if (attribute == null) {
            return null;
        }
        ImmutableList<String> values = attribute.getValues();
        if (values.isEmpty()) {
            return null;
        }
        try {
            return ProfileAttributePeriod.fromMonthYearPeriodString((String)values.get(0));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @CheckForNull
    public ProfileAttribute findFirstAttributeOfType(ProfileAttributeType type) {
        for (ProfileAttribute attr : this._attributes) {
            if (attr.getType() != type) continue;
            return attr;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("orderIndex", (Object)this._orderIndex).add("attributes", this._attributes.size()).toString();
    }

    @Nonnull
    public static Builder builder(@Nullable Integer orderIndex) {
        return new Builder(orderIndex);
    }

    @ParametersAreNonnullByDefault
    public static final class Builder {
        private final Integer _orderIndex;
        private final ImmutableList.Builder<ProfileAttribute> _profileAttributes;

        private Builder(@Nullable Integer orderIndex) {
            this._orderIndex = orderIndex;
            this._profileAttributes = ImmutableList.builder();
        }

        @Nonnull
        public Builder addAttributeValues(ProfileAttributeConfiguration attribute, ImmutableList<String> values) {
            this._profileAttributes.add((Object)new ProfileAttribute(attribute.getName(), attribute.getType(), values));
            return this;
        }

        @Nonnull
        public ProfileAttributeBlock build() {
            return new ProfileAttributeBlock(this._orderIndex, (ImmutableList<ProfileAttribute>)this._profileAttributes.build());
        }
    }
}

