/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.freiheit.toro.account.shared.model.settings.Birthday;
import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.profile.model.ProfileAttributes;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Profile {
    private final ProfileId _id;
    private final String _title;
    private final String _firstName;
    private final String _lastName;
    private final String _additionalTitle;
    private final String _fullName;
    private final String _imageUrl;
    private final ImmutableSet<PersonRole> _roles;
    private final boolean _active;
    private final boolean _blocked;
    private final boolean _deleted;
    private final boolean _visible;
    private final ImmutableSet<Action> _allowedActions;
    private final boolean _editRolesAllowed;
    private final ProfileAttributes _profileAttributes;
    private final boolean _usesDefaultImage;
    private final Birthday _birthday;
    private final BirthdayVisibility _birthdayVisibility;
    private final TimeZone _timezone;
    private final boolean _acceptedProfileImageLegalTerms;

    public Profile(ProfileId id, @Nullable String title, String firstName, String lastName, @Nullable String additionalTitle, String fullName, @Nullable String imageUrl, ImmutableSet<PersonRole> roles, boolean active, boolean blocked, boolean deleted, boolean visible, ImmutableSet<Action> allowedActions, boolean editRolesAllowed, @Nullable ProfileAttributes profileAttributes, boolean usesDefaultImage, @Nullable Birthday birthday, @Nullable BirthdayVisibility birthdayVisibility, @Nullable TimeZone timezone, boolean acceptedProfileImageLegalTerms) {
        this._id = id;
        this._title = title;
        this._firstName = firstName;
        this._lastName = lastName;
        this._additionalTitle = additionalTitle;
        this._fullName = fullName;
        this._imageUrl = imageUrl;
        this._roles = roles;
        this._active = active;
        this._blocked = blocked;
        this._deleted = deleted;
        this._visible = visible;
        this._allowedActions = allowedActions;
        this._editRolesAllowed = editRolesAllowed;
        this._profileAttributes = profileAttributes;
        this._usesDefaultImage = usesDefaultImage;
        this._birthday = birthday;
        this._birthdayVisibility = birthdayVisibility;
        this._timezone = timezone;
        this._acceptedProfileImageLegalTerms = acceptedProfileImageLegalTerms;
    }

    @Nonnull
    public ProfileId getId() {
        return this._id;
    }

    @CheckForNull
    public String getTitle() {
        return this._title;
    }

    @CheckForNull
    public String getAdditionalTitle() {
        return this._additionalTitle;
    }

    @Nonnull
    public String getFirstName() {
        return this._firstName;
    }

    @Nonnull
    public String getLastName() {
        return this._lastName;
    }

    @Nonnull
    public String getFullName() {
        return this._fullName;
    }

    @CheckForNull
    public String getImageUrl() {
        return this._imageUrl;
    }

    @Nonnull
    public ImmutableSet<PersonRole> getRoles() {
        return this._roles;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public boolean isUsesDefaultImage() {
        return this._usesDefaultImage;
    }

    public boolean isAcceptedProfileImageLegalTerms() {
        return this._acceptedProfileImageLegalTerms;
    }

    @Nonnull
    public ImmutableSet<Action> getAllowedActions() {
        return this._allowedActions;
    }

    public boolean isEditRolesAllowed() {
        return this._editRolesAllowed;
    }

    @CheckForNull
    public ProfileAttributes getProfileAttributes() {
        return this._profileAttributes;
    }

    @CheckForNull
    public Birthday getBirthday() {
        return this._birthday;
    }

    @CheckForNull
    public BirthdayVisibility getBirthdayVisibility() {
        return this._birthdayVisibility;
    }

    @CheckForNull
    public TimeZone getTimezone() {
        return this._timezone;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this._id).add("title", (Object)this._title).add("fullName", (Object)this._fullName).add("firstName", (Object)this._firstName).add("lastName", (Object)this._lastName).add("additionalTitle", (Object)this._additionalTitle).add("imageUrl", (Object)this._imageUrl).add("roles", this._roles.size()).add("active", this._active).add("blocked", this._blocked).add("deleted", this._deleted).add("visible", this._visible).add("editRolesAllowed", this._editRolesAllowed).add("allowedActions", this._allowedActions.size()).add("profileAttributes", (Object)this._profileAttributes).add("usesDefaultImage", this._usesDefaultImage).add("acceptedProfileImageLegalTerms", this._acceptedProfileImageLegalTerms).add("birthday", (Object)this._birthday).add("birthdayVisibility", (Object)this._birthdayVisibility).add("timezone", (Object)this._timezone).toString();
    }
}

