/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.profile.business.ProfileAttributeTranslationService;
import de.justsoftware.onx.profile.business.ProfileAttributesConfigPublisher;
import de.justsoftware.onx.profile.business.ProfileReadWriteDataService;
import de.justsoftware.onx.profile.business.events.ProfileAttributeConfigurationChangedEvent;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ProfileAttributesConfigPublisherImpl
implements ProfileAttributesConfigPublisher,
ApplicationListener<ContextRefreshedEvent>,
ServerEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileAttributesConfigPublisherImpl.class);
    private static final String TOPIC_NAME = "just.persons.profileAttributesConfig";
    private static final Callback LOG_ERROR_CALLBACK = new Callback(){

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                LOG.error("Could not publish profile attributes config", (Throwable)exception);
            }
        }
    };
    private final Producer<String, String> _producer;
    private final ProfileReadWriteDataService _profileReadWriteDataService;
    private final ProfileAttributeTranslationService _profileAttributeTranslationService;
    private final ObjectMapper _jucoObjectMapper;

    @Autowired
    public ProfileAttributesConfigPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, ProfileReadWriteDataService profileReadWriteDataService, ProfileAttributeTranslationService profileAttributeTranslationService, ObjectMapper jucoObjectMapper) {
        this._producer = producer;
        this._profileReadWriteDataService = profileReadWriteDataService;
        this._profileAttributeTranslationService = profileAttributeTranslationService;
        this._jucoObjectMapper = jucoObjectMapper;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.publishDynamicAttributeConfiguration();
    }

    @Override
    public void publishDynamicAttributeConfiguration() {
        if (this._producer == null) {
            return;
        }
        LOG.info("Sending dynamic attribute configuration to kafka");
        ImmutableSetMultimap<String, String> allProfileAttributeTranslations = this._profileAttributeTranslationService.getAllProfileAttributeTranslations();
        ProfileAttributesConfiguration completeConfig = this._profileReadWriteDataService.getAttributesConfiguration();
        ImmutableList attributeConfig = (ImmutableList)completeConfig.getSections().stream().flatMap(sectionCfg -> sectionCfg.getAttributes().stream()).filter(cfg -> ProfileAttributeSearchType.isSearchable(cfg) || cfg.isVisibleOnBadgeNullSafe()).map(cfg -> new ProfileAttributeConfigPublishModel((ProfileAttributeConfiguration)cfg, this.getTranslations((ProfileAttributeConfiguration)cfg, allProfileAttributeTranslations))).collect(ImmutableList.toImmutableList());
        this.sendData((ImmutableList<ProfileAttributeConfigPublishModel>)attributeConfig);
    }

    @Nonnull
    private SetMultimap<String, String> getTranslations(ProfileAttributeConfiguration cfg, ImmutableSetMultimap<String, String> allProfileAttributeTranslations) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        Optional.ofNullable(cfg.getValues()).orElse((ImmutableList<String>)ImmutableList.of()).forEach(value -> builder.putAll(value, (Iterable)allProfileAttributeTranslations.get(value)));
        return builder.build();
    }

    @Subscribe
    public void onProfileAttributeConfigurationChanged(ProfileAttributeConfigurationChangedEvent event) {
        this.publishDynamicAttributeConfiguration();
    }

    private void sendData(ImmutableList<ProfileAttributeConfigPublishModel> attributeConfig) {
        if (this._producer == null) {
            return;
        }
        try {
            this._producer.send(new ProducerRecord(TOPIC_NAME, (Object)"DEFAULT", (Object)this._jucoObjectMapper.writeValueAsString(attributeConfig)), LOG_ERROR_CALLBACK);
        }
        catch (JsonProcessingException e) {
            LOG.error("Could not publish profile attributes config", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean ready() {
        return this._producer != null;
    }

    @ParametersAreNonnullByDefault
    static class ProfileAttributeConfigPublishModel {
        private final ProfileAttributeType _type;
        private final String _name;
        private final boolean _visibleOnBadge;
        private final boolean _searchable;
        private final boolean _facetable;
        private final boolean _clickable;
        private final boolean _phoneNumber;
        private final SetMultimap<String, String> _translatableValues;

        public ProfileAttributeConfigPublishModel(ProfileAttributeConfiguration cfg, SetMultimap<String, String> translatableValues) {
            this._type = cfg.getType();
            this._name = cfg.getName();
            this._visibleOnBadge = cfg.isVisibleOnBadgeNullSafe();
            this._searchable = ProfileAttributeSearchType.isSearchable(cfg);
            this._facetable = ProfileAttributeSearchType.isFacetable(cfg);
            this._clickable = Boolean.TRUE.equals(cfg.isClickable());
            this._phoneNumber = Boolean.TRUE.equals(cfg.isPhoneNumber());
            this._translatableValues = translatableValues;
        }

        @Nonnull
        public ProfileAttributeType getType() {
            return this._type;
        }

        @Nonnull
        public String getName() {
            return this._name;
        }

        public boolean isVisibleOnBadge() {
            return this._visibleOnBadge;
        }

        public boolean isSearchable() {
            return this._searchable;
        }

        public boolean isFacetable() {
            return this._facetable;
        }

        public boolean isClickable() {
            return this._clickable;
        }

        public boolean isPhoneNumber() {
            return this._phoneNumber;
        }

        @Nonnull
        public SetMultimap<String, String> getTranslatableValues() {
            return this._translatableValues;
        }
    }
}

