/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.profile.business.ProfileAttributesChangesPublisher;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.business.events.ProfileAttributesChangedEvent;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ProfileAttributesChangesPublisherImpl
implements ProfileAttributesChangesPublisher,
ServerEventHandler {
    private static final int LOAD_PAGE_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(ProfileAttributesChangesPublisherImpl.class);
    private static final String TOPIC_NAME = "just.persons.profileAttributes";
    private static final Callback LOG_ERROR_CALLBACK = (metadata, exception) -> {
        if (exception != null) {
            LOG.error("Could not publish DynamicProfileAttributesChangedEvent", (Throwable)exception);
        }
    };
    private final Producer<String, String> _producer;
    private final ProfileService _profileService;
    private final PersonService _personService;

    @Autowired
    public ProfileAttributesChangesPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, ProfileService profileService, PersonService personService) {
        this._producer = producer;
        this._profileService = profileService;
        this._personService = personService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDynamicProfileAttributesChanged(ProfileAttributesChangedEvent event) {
        this.sendData((Set<ProfileId>)ImmutableSet.of((Object)event.getPersonId().asProfileId()));
    }

    @VisibleForTesting
    void sendData(Set<ProfileId> profileIds) {
        if (this._producer == null) {
            return;
        }
        ImmutableListMultimap<ProfileId, ProfileAttribute> attributes = this._profileService.getVisibleAttributesForInternalUseOnly(profileIds, (Predicate<ProfileAttributeConfiguration>)((Predicate)cfg -> cfg.isVisibleOnBadgeNullSafe() || ProfileAttributeSearchType.isSearchable(cfg)));
        profileIds.stream().forEach(id -> this.sendData((ProfileId)id, (Collection<ProfileAttribute>)attributes.get(id)));
    }

    @VisibleForTesting
    void sendData(ProfileId profileId, Collection<ProfileAttribute> attributes) {
        if (this._producer == null) {
            return;
        }
        JSONObject json = new JSONObject();
        try {
            String value;
            if (attributes.isEmpty()) {
                value = null;
            } else {
                for (ProfileAttribute attr : attributes) {
                    JSONArray attributeValues = json.optJSONArray(attr.getName());
                    if (attributeValues == null) {
                        attributeValues = new JSONArray();
                    }
                    attr.getValues().forEach(arg_0 -> ((JSONArray)attributeValues).put(arg_0));
                    json.put(attr.getName(), (Object)attributeValues);
                }
                value = json.toString();
            }
            this._producer.send(new ProducerRecord(TOPIC_NAME, (Object)Long.toString(profileId.getId()), (Object)value), LOG_ERROR_CALLBACK);
        }
        catch (JSONException e) {
            LOG.error("Could not publish DynamicProfileAttributesChangedEvent", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean ready() {
        return this._producer != null;
    }

    @Override
    public void publishAllForProfiles() {
        List<PersonId> allPersonIds = this._personService.getAllPersonIds(false, 0, Integer.MAX_VALUE);
        List partitions = Lists.partition(allPersonIds, (int)100);
        for (List personIds : partitions) {
            this.sendData(personIds.stream().map(PersonId::asProfileId).collect(Collectors.toSet()));
        }
    }
}

