/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business.impl;

import com.freiheit.toro.common.business.LanguageService;
import com.freiheit.toro.server.business.event.FlushCacheEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.FileWatchService;
import de.justsoftware.onx.common.business.I18nextService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.cache.SingleValueCache;
import de.justsoftware.onx.common.cache.SingleValueWarmedUpCacheFactory;
import de.justsoftware.onx.profile.business.ProfileAttributeTranslationService;
import de.justsoftware.onx.profile.business.events.ProfileAttributeConfigurationChangedEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ProfileAttributeTranslationServiceImpl
implements ServerEventHandler,
ProfileAttributeTranslationService,
InitializingBean {
    private static final Function<Object, Stream<Object>> TRANSLATION_MAP_VALUE_TRAVERSE = input -> {
        if (input instanceof Map) {
            Map map = (Map)input;
            return map.values().stream().filter(Objects::nonNull);
        }
        return Stream.of(new Object[0]);
    };
    private static final Function<Object, Object> TRANSLATION_PROFILE_VALUE_TRAVERSE = input -> {
        if (input instanceof Map) {
            Map map = (Map)input;
            return map.get("profileAttribute");
        }
        return null;
    };
    private static final Function<Object, Stream<?>> TRANSLATION_ENTRY_TRAVERSE = input -> {
        if (input instanceof Map) {
            return ((Map)input).entrySet().stream();
        }
        return Stream.of(new Object[0]);
    };
    private static final Function<Object, OneTranslation> TRANSLATION_TRANSFORMER = input -> {
        if (!(input instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)input;
        Object key = entry.getKey();
        Object value = entry.getValue();
        if (key == null || value == null) {
            return null;
        }
        return new OneTranslation(key.toString(), value.toString());
    };
    private static final Logger LOG = LoggerFactory.getLogger(ProfileAttributeTranslationServiceImpl.class);
    private static final ImmutableList<String> PROFILE_NAMESPACES = ImmutableList.of((Object)"profile-custom", (Object)"profile-attributes-default");
    private static final String CACHE_NAME = "ProfileAttributeTranslationsCache";
    private static final long ON_CHANGE_POLLING_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private final I18nextService _i18nextService;
    private final LanguageService _languageService;
    private final FileWatchService _fileWatcher;
    private final SingleValueCache<ImmutableTable<String, String, String>> _cache;

    @Autowired
    public ProfileAttributeTranslationServiceImpl(I18nextService i18nextService, LanguageService languageService, FileWatchService fileWatcher, SingleValueWarmedUpCacheFactory cacheFactory) {
        this._i18nextService = i18nextService;
        this._languageService = languageService;
        this._fileWatcher = fileWatcher;
        this._cache = cacheFactory.create(CACHE_NAME, ON_CHANGE_POLLING_INTERVAL, this::loadAllProfileTranslations);
    }

    @Override
    public ImmutableSetMultimap<String, String> getAllProfileAttributeTranslations() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Table.Cell cell : ((ImmutableTable)this._cache.get()).cellSet()) {
            String columnKey = (String)cell.getColumnKey();
            String value = (String)cell.getValue();
            if (columnKey == null || value == null) continue;
            builder.put((Object)columnKey, (Object)value);
        }
        return builder.build();
    }

    @Override
    public ImmutableMap<String, String> getProfileAttributeTranslations(String locale) {
        return ((ImmutableTable)this._cache.get()).row((Object)locale);
    }

    @Override
    public void flushCache() {
        this._cache.invalidate();
    }

    @Nonnull
    private ImmutableTable<String, String, String> loadAllProfileTranslations() {
        ImmutableSet<String> locales = this._languageService.getAvailableLanguageCode();
        Map<String, Object> allTranslations = this._i18nextService.getTranslation((List<String>)ImmutableList.copyOf(locales), (List<String>)PROFILE_NAMESPACES, true, true);
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (String locale : locales) {
            Object translationObject = allTranslations.get(locale);
            ImmutableList translations = translationObject != null ? (ImmutableList)Stream.of(translationObject).flatMap(TRANSLATION_MAP_VALUE_TRAVERSE).map(TRANSLATION_PROFILE_VALUE_TRAVERSE).flatMap(TRANSLATION_ENTRY_TRAVERSE).map(TRANSLATION_TRANSFORMER).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
            HashSet uniqueKeys = Sets.newHashSet();
            for (OneTranslation ot : translations) {
                if (uniqueKeys.contains(ot.getKey())) continue;
                uniqueKeys.add(ot.getKey());
                builder.put((Object)locale, (Object)ot.getKey(), (Object)ot.getValue());
            }
        }
        LOG.info("all profile translation loaded.");
        return builder.build();
    }

    @Subscribe
    public void onTranslationFileChanged(FileWatchService.FileChangeEvent event) {
        if (FileWatchService.FileChangeEvent.PROFILE_TRANSLATION_CHANGED.equals(event)) {
            LOG.info("profile translations changed on the filesystem - flushing profile translation cache");
            this.flushCache();
        }
    }

    @Subscribe
    public void onFlushCacheEvent(FlushCacheEvent event) {
        LOG.info("global flush cache triggered - flushing profile translation cache");
        this.flushCache();
    }

    @Subscribe
    public void onNewProfileConfiguration(ProfileAttributeConfigurationChangedEvent event) {
        LOG.info("profile configuration changed - flushing profile translation cache");
        this.flushCache();
    }

    public void afterPropertiesSet() {
        this._fileWatcher.registerWatchesFiles((List<URL>)this._i18nextService.getResourceURLs((List<String>)PROFILE_NAMESPACES), FileWatchService.FileChangeEvent.PROFILE_TRANSLATION_CHANGED);
    }

    private static final class OneTranslation
    implements Map.Entry<String, String> {
        private final String _key;
        private final String _value;

        @ParametersAreNonnullByDefault
        public OneTranslation(String key, String value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException("value is immutable");
        }
    }
}

