/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;

public interface PersonTeaserModel
extends Serializable,
Identifiable<PersonId> {
    public static final Function<PersonTeaserModel, String> TO_FULL_NAME = new NullPermeableFunction<PersonTeaserModel, String>(){

        @Override
        protected String applySafe(PersonTeaserModel input) {
            return input.getFullName();
        }
    };
    public static final Function<PersonTeaserModel, String> TO_FULL_NAME_LASTNAME_FIRST = new NullPermeableFunction<PersonTeaserModel, String>(){

        @Override
        protected String applySafe(PersonTeaserModel input) {
            return Joiner.on((String)", ").skipNulls().join((Object)input.getLastname(), (Object)input.getFirstname(), new Object[0]);
        }
    };
    public static final Function<PersonTeaserModel, PersonId> TO_ID = new NullPermeableFunction<PersonTeaserModel, PersonId>(){

        @Override
        protected PersonId applySafe(PersonTeaserModel input) {
            return (PersonId)input.getId();
        }
    };
    public static final Predicate<PersonTeaserModel> NOT_DELETED = new NullIsFalsePredicate<PersonTeaserModel>(){

        @Override
        protected boolean applySafe(PersonTeaserModel input) {
            return !input.isDeleted();
        }
    };
    public static final Predicate<PersonTeaserModel> IS_VISIBLE = new NullIsFalsePredicate<PersonTeaserModel>(){

        @Override
        protected boolean applySafe(PersonTeaserModel input) {
            return input.isVisible();
        }
    };

    public boolean isActive();

    public String getLanguageId();

    public boolean isVisible();

    public String getLogo();

    public String getFullName();

    public String getShortName();

    public boolean isBlocked();

    public boolean isDeleted();

    public String getLastname();

    public String getFirstname();

    public boolean isInvitationPending();
}

