/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettings;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class EmailNotificationSettingsBean
implements EmailNotificationSettings,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _emailNotificationConcernMe;
    private boolean _emailNotificationsVisible;
    private boolean _chatEmailNotificationsEnabled;
    private PersonId _personId;

    @Deprecated
    public EmailNotificationSettingsBean() {
    }

    public EmailNotificationSettingsBean(@Nonnull PersonId personId, @Nonnull EmailNotificationSettings settings) {
        this._personId = personId;
        this._emailNotificationConcernMe = settings.isEmailNotificationConcernMe();
        this._chatEmailNotificationsEnabled = settings.isChatEmailNotificationEnabled();
    }

    public EmailNotificationSettingsBean(@Nonnull DBEmailNotificationSettings settings) {
        this._personId = settings.getPersonId();
        this._emailNotificationConcernMe = settings.isEmailNotificationsActivated();
    }

    public EmailNotificationSettingsBean(@Nonnull PersonId personId, boolean concernMe, boolean chatEmailNotificationsEnabled) {
        this._personId = personId;
        this._emailNotificationConcernMe = concernMe;
        this._chatEmailNotificationsEnabled = chatEmailNotificationsEnabled;
    }

    public EmailNotificationSettingsBean(@Nonnull DBEmailNotificationSettings settings, boolean chatEmailNotificationsEnabled) {
        this._personId = settings.getPersonId();
        this._emailNotificationConcernMe = settings.isEmailNotificationsActivated();
        this._chatEmailNotificationsEnabled = chatEmailNotificationsEnabled;
    }

    @Override
    public boolean isEmailNotificationConcernMe() {
        return this._emailNotificationConcernMe;
    }

    @Override
    public boolean isChatEmailNotificationEnabled() {
        return this._chatEmailNotificationsEnabled;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    public boolean isEmailNotificationsVisible() {
        return this._emailNotificationsVisible;
    }

    public void setEmailNotificationsVisible(boolean emailNotificationsVisible) {
        this._emailNotificationsVisible = emailNotificationsVisible;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("emailNotificationConcernMe", this._emailNotificationConcernMe).add("emailNotificationsVisible", this._emailNotificationsVisible).add("chatEmailNotificationsEnabled", this._chatEmailNotificationsEnabled).add("personId", (Object)this._personId).toString();
    }
}

