/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.model;

import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.auditing.shared.AuditSensitive;
import de.justsoftware.onx.common.shared.model.Field;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBPerson
implements Identifiable<PersonId>,
Serializable {
    public static final Function<DBPerson, String> TO_FULL_NAME = new NullPermeableFunction<DBPerson, String>(){

        @Override
        public String applySafe(DBPerson person) {
            return person.getFullName();
        }
    };
    public static final Function<DBPerson, String> TO_LAST_NAME = new NullPermeableFunction<DBPerson, String>(){

        @Override
        public String applySafe(DBPerson person) {
            return person.getLastName();
        }
    };
    public static final Function<DBPerson, String> TO_EMAIL = new NullPermeableFunction<DBPerson, String>(){

        @Override
        public String applySafe(DBPerson person) {
            return person.getEmail();
        }
    };
    public static final Function<DBPerson, String> TO_SHORTNAME = new NullPermeableFunction<DBPerson, String>(){

        @Override
        public String applySafe(DBPerson person) {
            return person.getShortName();
        }
    };
    public static final Predicate<DBPerson> CAN_LOGIN = new NullIsFalsePredicate<DBPerson>(){

        @Override
        protected boolean applySafe(DBPerson input) {
            return input.canLogin();
        }
    };
    public static final Predicate<? super DBPerson> NOT_DELETED = new NullIsFalsePredicate<DBPerson>(){

        @Override
        protected boolean applySafe(DBPerson input) {
            return !input.isDeleted();
        }
    };
    public static final Predicate<? super DBPerson> IS_ACTIVE = new NullIsFalsePredicate<DBPerson>(){

        @Override
        protected boolean applySafe(DBPerson input) {
            return input.isActive();
        }
    };
    public static final Function<DBPerson, String> GET_LANGUAGE = new NullPermeableFunction<DBPerson, String>(){

        @Override
        protected String applySafe(DBPerson input) {
            return input.getLanguageId();
        }
    };
    public static final Ordering<DBPerson> BY_LASTNAME_ASC = new Ordering<DBPerson>(){

        public int compare(DBPerson left, DBPerson right) {
            return Ordering.natural().compare((Object)left.getLastName(), (Object)right.getLastName());
        }
    };
    private static final long serialVersionUID = 1L;
    private PersonId _id;
    @Field(id="person.title")
    private String _title;
    @Field(id="person.firstname", required=true)
    private String _firstName;
    @Field(id="person.lastname", required=true)
    private String _lastName;
    @Field(id="person.email", required=true)
    private String _email;
    private String _newmail;
    @Field(id="person.birthday", required=false)
    private DateWithoutTimezone _birthday;
    private BirthdayVisibility _birthdayVisibility;
    private String _image;
    private String _languageId;
    private TimeZone _timeZone;
    private boolean _active;
    @Field(id="person.terms")
    private Boolean _termsAccepted;
    private String _tags;
    @AuditSensitive
    private String _passwordHash;
    private boolean _blocked;
    private String _hashedId;
    private DateWithoutTimezone _lastLoginDate;
    @Field(id="person.additionalTitle")
    private String _additionalTitle;
    private Date _modifyDate;
    private Date _createDate;
    private boolean _deleted = false;

    public DBPerson() {
    }

    public DBPerson(@Nonnull DBPerson from) {
        this._modifyDate = Dates.clone(from._modifyDate);
        this._createDate = Dates.clone(from._createDate);
        this._id = from._id;
        this._timeZone = from._timeZone;
        this._firstName = from._firstName;
        this._lastName = from._lastName;
        this._email = from._email;
        this._newmail = from._newmail;
        this._birthday = from._birthday;
        this._birthdayVisibility = from._birthdayVisibility;
        this._image = from._image;
        this._languageId = from._languageId;
        this._active = from._active;
        this._termsAccepted = from._termsAccepted;
        this._tags = from._tags;
        this._passwordHash = from._passwordHash;
        this._blocked = from._blocked;
        this._hashedId = from._hashedId;
        this._lastLoginDate = from._lastLoginDate;
        this._additionalTitle = from._additionalTitle;
        this._deleted = from._deleted;
        this._title = from._title;
    }

    @Override
    public final PersonId getId() {
        return this._id;
    }

    public final void setId(PersonId id) {
        this._id = id;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String title) {
        this._title = title;
    }

    public final String getFirstName() {
        return this._firstName;
    }

    public final void setFirstName(String firstName) {
        this._firstName = firstName;
    }

    public final String getLastName() {
        return this._lastName;
    }

    public final void setLastName(String lastName) {
        this._lastName = lastName;
    }

    public String getEmail() {
        return this._email;
    }

    public final void setEmail(String email) {
        this._email = email;
    }

    @CheckForNull
    public final DateWithoutTimezone getBirthday() {
        return Dates.clone(this._birthday);
    }

    public final void setBirthday(@Nullable DateWithoutTimezone birthday) {
        this._birthday = Dates.clone(birthday);
    }

    @CheckForNull
    public final String getImage() {
        return this._image;
    }

    public final void setImage(String image) {
        this._image = image;
    }

    @CheckForNull
    public final String getLanguageId() {
        return this._languageId;
    }

    public final void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    @CheckForNull
    public final TimeZone getTimeZone() {
        return this._timeZone;
    }

    public final void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public final String getTags() {
        return this._tags;
    }

    public final void setTags(String tags) {
        this._tags = tags;
    }

    public final boolean isActive() {
        return this._active;
    }

    public final void setActive(boolean active) {
        this._active = active;
    }

    public final Boolean getTermsAccepted() {
        return this._termsAccepted;
    }

    public final void setTermsAccepted(Boolean termsAccepted) {
        this._termsAccepted = termsAccepted;
    }

    @Nonnull
    public final String getFullName() {
        StringBuilder result = new StringBuilder();
        if (this._title != null && this._title.trim().length() > 0) {
            result.append(this._title);
            result.append(" ");
        }
        result.append(this._firstName).append(" ").append(this._lastName);
        if (this._additionalTitle != null && this._additionalTitle.trim().length() > 0) {
            result.append(", ").append(this._additionalTitle);
        }
        return result.toString();
    }

    public final String getShortName() {
        return this._firstName + " " + this._lastName;
    }

    public final BirthdayVisibility getBirthdayVisibility() {
        return this._birthdayVisibility;
    }

    public final void setBirthdayVisibility(BirthdayVisibility birthdayVisibility) {
        this._birthdayVisibility = birthdayVisibility;
    }

    public final String getPasswordHash() {
        return this._passwordHash;
    }

    public final void setPasswordHash(String passwordHash) {
        this._passwordHash = passwordHash;
    }

    public final String getNewmail() {
        return this._newmail;
    }

    public final void setNewmail(String newmail) {
        this._newmail = newmail;
    }

    public final boolean isBlocked() {
        return this._blocked;
    }

    public final void setBlocked(boolean blocked) {
        this._blocked = blocked;
    }

    public final String getHashedId() {
        return this._hashedId;
    }

    public final void setHashedId(String hashedId) {
        this._hashedId = hashedId;
    }

    public final DateWithoutTimezone getLastLoginDate() {
        return this._lastLoginDate;
    }

    public final void setLastLoginDate(DateWithoutTimezone lastLoginDate) {
        this._lastLoginDate = lastLoginDate;
    }

    public final String getAdditionalTitle() {
        return this._additionalTitle;
    }

    public final void setAdditionalTitle(String additionalTitle) {
        this._additionalTitle = additionalTitle;
    }

    public final Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public final void setModifyDate(Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    public final Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    public final void setCreateDate(Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    public final boolean isDeleted() {
        return this._deleted;
    }

    public final void setDeleted(boolean deleted) {
        this._deleted = deleted;
    }

    public boolean canLogin() {
        return this._active && !this._blocked && !this._deleted;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("title", (Object)this._title).add("firstName", (Object)this._firstName).add("lastName", (Object)this._lastName).add("email", (Object)this._email).add("newmail", (Object)this._newmail).add("birthday", (Object)this._birthday).add("birthdayVisibility", (Object)this._birthdayVisibility).add("image", (Object)this._image).add("languageId", (Object)this._languageId).add("timeZone", (Object)this._timeZone).add("active", this._active).add("termsAccepted", (Object)this._termsAccepted).add("tags", (Object)this._tags).add("passwordHash", (Object)this._passwordHash).add("blocked", this._blocked).add("hashedId", (Object)this._hashedId).add("lastLoginDate", (Object)this._lastLoginDate).add("additionalTitle", (Object)this._additionalTitle).add("modifyDate", (Object)this._modifyDate).add("createDate", (Object)this._createDate).add("deleted", this.isDeleted()).toString();
    }
}

