/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.integration.persistence.PersonSettingsDao;
import de.justsoftware.onx.person.model.DBHomeScreenEntry;
import java.sql.SQLException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisPersonSettingsDAO
implements PersonSettingsDao {
    private final IbatisStatementBuilder _stmtBuilder;

    @Autowired
    public IbatisPersonSettingsDAO(StatementBuilderFactory stmtBuilderFactory) {
        this._stmtBuilder = stmtBuilderFactory.ibatistStatementBuilder("Settings");
    }

    @Override
    public ImmutableMap<String, String> getPersonSettings(PersonId personId) {
        return this.getPersonSettings((Set<PersonId>)ImmutableSet.of((Object)personId)).row((Object)personId);
    }

    @Override
    public ImmutableTable<PersonId, String, String> getPersonSettings(Set<PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._stmtBuilder.select("getSettings").partition(personIds)).asTable("personId", "key", "value");
    }

    @Override
    public void storePersonSetting(PersonId personId, String key, String value) {
        this.storePersonSettings((ImmutableTable<PersonId, String, String>)ImmutableTable.of((Object)personId, (Object)key, (Object)value));
    }

    @Override
    public void storePersonSettings(final ImmutableTable<PersonId, String, String> settings) {
        this._stmtBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

            @Override
            public void execute(SqlMapClient sqlMapClient) throws SQLException {
                for (Table.Cell setting : settings.cellSet()) {
                    IbatisPersonSettingsDAO.this._stmtBuilder.insertDbSpecific("insertSetting").param("personId", setting.getRowKey(), "key", setting.getColumnKey(), "value", setting.getValue());
                    IbatisPersonSettingsDAO.this._stmtBuilder.update("updateSetting").param("personId", setting.getRowKey(), "key", setting.getColumnKey(), "value", setting.getValue());
                }
            }
        });
    }

    @Override
    public void deleteSettingsForPersons(Set<PersonId> personIds) {
        this._stmtBuilder.delete("deleteSettingsForPersons").partition(personIds);
    }

    @Override
    public void deleteSettingForPerson(PersonId personId, String key) {
        this._stmtBuilder.delete("deleteSettingForPerson").param("personId", personId, "key", key);
    }

    @Override
    public ImmutableList<DBHomeScreenEntry> getHomeScreenEntries(PersonId personId) {
        return this._stmtBuilder.select("getHomeScreenEntries").param(personId).asList();
    }

    @Override
    public void deleteHomeScreenEntries(PersonId personId) {
        this._stmtBuilder.delete("deleteHomeScreenEntries").param(personId);
    }

    @Override
    public void insertHomeScreenEntries(ImmutableList<DBHomeScreenEntry> homeScreenEntries) {
        this._stmtBuilder.insertDbSpecific("insertHomeScreenEntries").partition(ImmutableSet.copyOf(homeScreenEntries));
    }
}

