/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.integration.persistence.DBPersonRelation;
import de.justsoftware.onx.person.integration.persistence.FriendsDAO;
import de.justsoftware.onx.person.shared.model.PersonIdWithMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class IbatisFriendsDAO
implements FriendsDAO {
    private static final String NAMESPACE = "Friends.";
    private final SqlMapClient _sqlMapper;
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisFriendsDAO(StatementBuilderFactory statementBuilderFactory, @Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("Friends");
        this._sqlMapper = sqlMapClient;
    }

    @Override
    public List<DBPersonRelation> getFriendRelationsOf(Set<? extends PersonId> persons) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "Friends.getFriendRelationsOf", ImmutableSet.copyOf(persons), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void removeFriend(PersonId loggedInPersonId, PersonId friendId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "Friends.removeFriend", ImmutableMap.of((Object)"userid", (Object)loggedInPersonId, (Object)"friendid", (Object)friendId));
    }

    @Override
    public void removeInvitation(PersonId personId, PersonId friendId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "Friends.removeInvitation", ImmutableMap.of((Object)"userId", (Object)personId, (Object)"friendId", (Object)friendId));
    }

    @Override
    public void addInvitation(PersonId personId, PersonId friendId, String message) {
        HashMap params = Maps.newHashMap();
        params.put("userId", personId);
        params.put("friendId", friendId);
        params.put("message", message);
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Friends.addInvitation", params);
    }

    @Override
    public boolean hasInvited(PersonId personId, PersonId friendId) {
        return Boolean.TRUE.equals(IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Friends.hasInvited", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"friendId", (Object)friendId)));
    }

    @Override
    public List<PersonIdWithMessage> getInvitations(PersonId personId) {
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "Friends.getInvitations", personId);
    }

    @Override
    public void addFriend(PersonId personId, PersonId friendId) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Friends.addFriend", ImmutableMap.of((Object)"userId", (Object)personId, (Object)"friendId", (Object)friendId));
    }

    @Override
    public void deleteFriendshipsForDeletedPersons(Set<PersonId> personIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "Friends.deleteFriendsForPerson", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void deleteInvitationsForDeletedPersons(Set<PersonId> personIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "Friends.deleteInvitationsForPerson", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public int forAllFriendships(BiConsumer<PersonId, PersonId> consumer) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("forAllFriendships").noParam()).executeWithBiConsumer(DBPersonRelation::getFrom, DBPersonRelation::getTo, consumer);
    }
}

