/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.StartpageItemHandler;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="startpageItemHandler")
public class StartpageItemHandlerImpl
implements StartpageItemHandler {
    @Autowired
    private PersonService _personService;

    @Override
    public Map<StartpageId, StartpageItem> getByIds(ImmutableSet<StartpageId> ids) {
        ImmutableSet personIds = FluentIterable.from(ids).transform(StartpageId.TO_PERSON_ID).toSet();
        ImmutableMap<PersonId, DBPerson> persons = this._personService.getPersonsByIds((Set<PersonId>)personIds);
        HashMap result = Maps.newHashMap();
        for (PersonId personId : personIds) {
            DBPerson person = (DBPerson)persons.get(personId);
            if (person == null) continue;
            result.put(personId.asStartpageId(), new StartpageItem(person));
        }
        return result;
    }
}

