/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.account.business.VerificationCodeService;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.business.LanguageService;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContext;
import de.justsoftware.onx.common.business.BackendException;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.ValidationError;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticPermissionAction;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityInvitationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.like.integration.persistence.LikeDAO;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.mail.business.ActivationLinkMailService;
import de.justsoftware.onx.mail.business.RegistrationMailService;
import de.justsoftware.onx.person.business.PasswordResetCodeGenerator;
import de.justsoftware.onx.person.business.PasswordResetRequestService;
import de.justsoftware.onx.person.business.PersonInsertCommand;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonValidator;
import de.justsoftware.onx.person.business.RegistrationService;
import de.justsoftware.onx.person.business.model.RegistrationFields;
import de.justsoftware.onx.person.business.model.RegistrationModel;
import de.justsoftware.onx.person.business.model.RegistrationValidationException;
import de.justsoftware.onx.person.business.util.RegistrationFieldUtil;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.presentation.shared.model.StaticRegistrationAttribute;
import de.justsoftware.onx.person.shared.model.PasswordResetRequest;
import de.justsoftware.onx.person.shared.model.RegistrationResult;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.model.Profile;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfileValidationErrorMessage;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionSystemException;

@Service(value="registrationService")
public class RegistrationServiceImpl
implements RegistrationService {
    private static final Duration REGISTRATION_PASSWORD_RESET_CODE_LIFETIME = Duration.ofDays(1L);
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationServiceImpl.class);
    @Autowired
    private Settings _settings;
    @Autowired
    private PersonService _personService;
    @Autowired
    private VerificationCodeService _verificationCodeService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private EntityMemberWorkflowService _entityMemberWorkflowService;
    @Autowired
    private EntityInvitationWorkflowService _entityInvitationService;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private PersonValidator _personValidator;
    @Autowired
    private LanguageService _languageService;
    @Autowired
    private EntityChildrenService _entityChildrenService;
    @Autowired
    private ActivationLinkMailService _activateLinkMailService;
    @Autowired
    private RegistrationMailService _registrationMailService;
    @Autowired
    private PasswordResetCodeGenerator _resetCodeGenerator;
    @Autowired
    private ProfileService _profileService;
    @Autowired
    private JucoPasswordEncoder _passwordEncoder;
    @Autowired
    private PersonTenantService _personTenantService;
    @Autowired
    private ConfigService _configService;
    @Autowired
    private TenantService _tenantService;
    @Autowired
    private Clock _clock;
    @Autowired
    private PasswordResetRequestService _passwordResetRequestService;
    @Autowired
    private EntityDAO _entityDao;
    @Autowired
    private LikeDAO _likeDao;

    @Override
    public RegistrationResult register(RegistrationModel registrationModel, String language) throws RegistrationValidationException {
        this.validate(registrationModel);
        try {
            return this.registerNewUser(registrationModel, language, false, registrationModel.getTenantId());
        }
        catch (ValidatableException e) {
            throw this.toRegistrationValidationException(e);
        }
        catch (BackendException | RuntimeException e) {
            LOG.error("Backend error occured while inserting new user during registration. Rolling back.", (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    @Nonnull
    private RegistrationValidationException toRegistrationValidationException(@Nonnull ValidatableException e) {
        ImmutableListMultimap.Builder errorMessages = ImmutableListMultimap.builder();
        for (Map.Entry<String, Collection<ValidationError>> errors : e.getErrors().entrySet()) {
            Stream<String> messages = errors.getValue().stream().map(error -> error.getMessage().getKey());
            errorMessages.putAll((Object)errors.getKey(), messages::iterator);
        }
        return new RegistrationValidationException((ImmutableListMultimap<String, String>)errorMessages.build());
    }

    private void sendPasswordResetMail(@Nonnull PersonId personId) {
        DBPerson person = this._personService.getPersonById(personId);
        if (person == null) {
            LOG.warn("Could not resolve person {}. Skipping to send email for registration.", (Object)personId);
            return;
        }
        LocalDateTime resetCodeExpiry = LocalDateTime.now(this._clock).plus(REGISTRATION_PASSWORD_RESET_CODE_LIFETIME);
        PasswordResetRequest resetRequest = this._resetCodeGenerator.generatePasswordResetRequest(personId, resetCodeExpiry);
        boolean mailSentSuccessfully = this._registrationMailService.sendSuccessfulRegistrationEmail(person, resetRequest.getResetPath());
        if (mailSentSuccessfully) {
            this._passwordResetRequestService.registerPasswordResetRequest(resetRequest);
        }
    }

    private void saveProfileAttributes(@Nonnull PersonId id, @Nonnull ImmutableMap<String, ProfileAttributeBlock> profileAttributes) throws RegistrationValidationException {
        if (!profileAttributes.isEmpty()) {
            try {
                this._profileService.saveProfileAttributeBlocksFromRegistration(id.asProfileId(), profileAttributes, this._authorizationContextProvider.getAuthorizationContextForUser(id));
            }
            catch (ProfileValidationException e) {
                throw new RegistrationValidationException((ImmutableListMultimap<String, String>)ImmutableListMultimap.copyOf(this.transformProfileValidationErrors(e.getValidationErrors())));
            }
        }
    }

    @Nonnull
    private RegistrationResult registerNewUser(@Nonnull RegistrationModel registrationModel, @Nullable String language, boolean autoActivated, TenantId tenantId) throws RegistrationValidationException, ValidatableException, BackendException {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        boolean setActive = autoActivated || !this._settings.isActivationViaOptInEnabled();
        DBPerson newPerson = this.saveRegisteredUser(registrationModel, language, setActive, eventCollector);
        PersonId personId = newPerson.getId();
        EntityId entityId = registrationModel.getEntityId();
        this._personTenantService.addPersonToTenant(personId, tenantId).waitForOffsets();
        eventCollector.fireEvents(this._eventBus);
        this.createEntitySubscriptions(tenantId, personId);
        this.saveProfileAttributes(personId, registrationModel.getProfileAttributes());
        RegistrationResult.AccountStatus resultStatus = this.updateAccountStatus(newPerson, entityId, setActive);
        return new RegistrationResult(personId, resultStatus);
    }

    private void createEntitySubscriptions(@Nonnull TenantId tenantId, @Nonnull PersonId personId) {
        if (this._settings.isImportPersonsEnabled()) {
            return;
        }
        ImmutableMap<EntityId, SubscriptionType> entitiesBySubscriptionType = this._entityDao.getEntitySubscriptionsByTenantId(tenantId);
        ImmutableSetMultimap.Builder subscriptionsBuilder = ImmutableSetMultimap.builder();
        entitiesBySubscriptionType.forEach((id, subscriptionType) -> {
            DBEntity dbEntity = this._entityDao.getEntityById((EntityId)id);
            boolean entityIsPublic = this._entityService.visibleForAllPersons(dbEntity);
            if (entityIsPublic) {
                subscriptionsBuilder.put(id, (Object)subscriptionType);
            }
        });
        this._likeDao.insertSubscriptionsForPerson((SetMultimap<? extends ItemId, SubscriptionType>)subscriptionsBuilder.build(), SubscriptionState.SUBSCRIBED, personId);
    }

    @Nonnull
    private RegistrationResult.AccountStatus updateAccountStatus(@Nonnull DBPerson newPerson, @Nullable EntityId entityId, boolean setActive) throws ValidatableException {
        if (setActive) {
            if (this._settings.isBlockUserAfterRegistrationEnabled()) {
                this._personService.setPersonBlocked(newPerson.getId(), true, EverythingAllowedAuthorizationCheckContext.INSTANCE);
                return RegistrationResult.AccountStatus.ACCOUNT_BLOCKED;
            }
            return RegistrationResult.AccountStatus.READY_FOR_LOGIN;
        }
        DBEntity entity = this._entityService.getById(entityId);
        this._activateLinkMailService.sendActivationLinkMail(newPerson, entity, this.generateActivationLink(newPerson));
        return RegistrationResult.AccountStatus.ACCOUNT_INACTIVE;
    }

    @Nonnull
    protected DBPerson saveRegisteredUser(@Nonnull RegistrationModel registrationModel, @Nullable String languageCode, boolean activated, ServerEventCollector eventCollector) throws ValidatableException {
        final DBPerson dbPerson = this.createDBPerson(registrationModel, languageCode, activated);
        PersonInsertCommand command = new PersonInsertCommand(){

            @Override
            public DBPerson execute(DBPerson object) {
                return dbPerson;
            }
        };
        PersonId savedUserId = this._personService.savePerson(null, command, PersonService.FeedMessageControl.GENERATE_FEED_MESSAGE, eventCollector);
        dbPerson.setId(savedUserId);
        return dbPerson;
    }

    @Override
    public String generateActivationLink(DBPerson p) {
        String code = this._verificationCodeService.generateUserActivationCodeForId(p.getId());
        return "/activateAccount/" + code;
    }

    @Nonnull
    protected DBPerson createDBPerson(@Nonnull RegistrationModel registrationModel, @Nullable String languageCode, boolean activated) {
        DBPerson result = new DBPerson();
        result.setTitle(registrationModel.getTitle());
        result.setBirthday(registrationModel.getBirthday());
        result.setFirstName(registrationModel.getFirstname());
        result.setLastName(registrationModel.getLastname());
        result.setEmail(Strings.nullToEmpty((String)registrationModel.getEmail()).trim().toLowerCase());
        if (languageCode != null && this._languageService.getAvailableLanguageCode().contains((Object)languageCode)) {
            result.setLanguageId(languageCode);
        } else {
            result.setLanguageId(this._settings.defaultLanguage());
        }
        result.setTermsAccepted(registrationModel.isTermsAccepted());
        result.setPasswordHash(this._passwordEncoder.encode(Strings.nullToEmpty((String)registrationModel.getPassword())));
        result.setActive(activated);
        result.setAdditionalTitle(registrationModel.getAdditionalTitle());
        return result;
    }

    private void validate(@Nonnull RegistrationModel registrationModel) throws RegistrationValidationException {
        ImmutableListMultimap<String, ValidationError> staticValidationErrors = this._personValidator.validateStaticRegistrationFields(registrationModel);
        ImmutableListMultimap<String, ProfileValidationErrorMessage> profileAttributeValidationErrors = this._profileService.validateRegistrationProfileAttributes(registrationModel.getProfileAttributes());
        if (staticValidationErrors.isEmpty() && profileAttributeValidationErrors.isEmpty()) {
            return;
        }
        ImmutableListMultimap.Builder resultBuilder = ImmutableListMultimap.builder();
        resultBuilder.putAll((Multimap)Multimaps.transformValues(staticValidationErrors, error -> error.getMessage().getKey()));
        resultBuilder.putAll(this.transformProfileValidationErrors(profileAttributeValidationErrors));
        throw new RegistrationValidationException((ImmutableListMultimap<String, String>)resultBuilder.build());
    }

    @Nonnull
    private ListMultimap<String, String> transformProfileValidationErrors(@Nonnull ImmutableListMultimap<String, ProfileValidationErrorMessage> profileAttributeValidationErrors) {
        return Multimaps.transformValues(profileAttributeValidationErrors, error -> error.getCode().getCode());
    }

    @Override
    public void requestActivation(String email) {
        if (!this._settings.isActivationViaOptInEnabled()) {
            return;
        }
        DBPerson person = this._personService.getPersonByEmail(email);
        if (person != null && !person.isActive() && !person.isBlocked()) {
            this._activateLinkMailService.sendActivationLinkMail(person, this.generateActivationLink(person));
        }
    }

    @Override
    public RegistrationFields getRegistrationFields(String email) {
        ProfileAttributesConfiguration profileAttributesCfg = this._profileService.getAttributesConfigurationForRegistration(null);
        ImmutableSet allFieldNames = FluentIterable.from(profileAttributesCfg.getAllAttributeNames()).transform(name -> "person.dynamic." + name).toSet();
        ArrayList staticAttributes = Lists.newArrayList();
        for (String field : this._personValidator.getRegistrationFields()) {
            if (RegistrationFieldUtil.ALL_STATIC_FIELDS.contains((Object)field)) {
                staticAttributes.remove(field);
                staticAttributes.add(field);
                continue;
            }
            if (allFieldNames.contains((Object)field)) continue;
            LOG.warn("Field '{}' is configured in 'Settings/profile/register/available person fields', but does not exist, ignoring it.", (Object)field);
        }
        return new RegistrationFields(this.createRegistrationStaticAttributes(staticAttributes), profileAttributesCfg.getSections(), email);
    }

    @Nonnull
    private ImmutableList<StaticRegistrationAttribute> createRegistrationStaticAttributes(@Nonnull Iterable<String> staticAttributes) {
        final ImmutableMap<String, Integer> fieldLengths = this._personValidator.getFieldLengths();
        return FluentIterable.from(staticAttributes).transform((Function)new NullPermeableFunction<String, StaticRegistrationAttribute>(){

            @Override
            protected StaticRegistrationAttribute applySafe(String input) {
                return new StaticRegistrationAttribute(input, RegistrationFieldUtil.REQUIRED_STATIC_FIELDS.contains((Object)input), (Integer)fieldLengths.get((Object)input));
            }
        }).toList();
    }

    @Override
    public boolean isEmailRegistered(String email) {
        return this._personService.isEmailRegistered((Set<String>)ImmutableSet.of((Object)email)).get((Object)email) != null;
    }

    @Override
    public Profile createProfile(RegistrationModel registrationModel, AuthorizationCheckContextWithUserId authCtx) throws RegistrationValidationException, PermissionDeniedException {
        TenantId tenantId = authCtx.getTenantId();
        authCtx.check((ItemId)tenantId, (Action)StaticPermissionAction.MANAGE);
        ImmutableListMultimap<String, ValidationError> errors = this._personValidator.validateStaticRegistrationFields(registrationModel);
        if (!errors.isEmpty()) {
            throw this.toRegistrationValidationException(new ValidatableException(errors));
        }
        try {
            RegistrationResult result = this.registerNewUser(registrationModel, null, true, tenantId);
            return Objects.requireNonNull(this._profileService.getProfileById(result.getPersonId().asProfileId(), authCtx));
        }
        catch (ValidatableException e) {
            throw this.toRegistrationValidationException(e);
        }
        catch (BackendException | RuntimeException e) {
            LOG.error("Backend error occured while creating a profile for new user. Rolling back.", (Throwable)e);
            throw new TransactionSystemException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ProfileId createProfileWithoutAuthCheck(RegistrationModel registrationModel) throws RegistrationValidationException {
        ImmutableListMultimap<String, ValidationError> errors = this._personValidator.validateEmailAndPasswordOnly(registrationModel);
        if (!errors.isEmpty()) {
            throw this.toRegistrationValidationException(new ValidatableException(errors));
        }
        try {
            RegistrationResult result = this.registerNewUser(registrationModel, null, true, registrationModel.getTenantId());
            if (this._settings.sendPasswordResetCodeMailAfterRegistration()) {
                this.sendPasswordResetMail(result.getPersonId());
            }
            return result.getPersonId().asProfileId();
        }
        catch (ValidatableException e) {
            throw this.toRegistrationValidationException(e);
        }
        catch (BackendException | RuntimeException e) {
            LOG.error("Backend error occured while creating a profile for new user. Rolling back.", (Throwable)e);
            throw new TransactionSystemException(e.getMessage(), (Throwable)e);
        }
    }
}

