/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.business.PersonTenantDeletionHandler;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonTenantDeletionHandlerImpl
implements PersonTenantDeletionHandler {
    private final PersonTenantService _personTenantService;

    public PersonTenantDeletionHandlerImpl(PersonTenantService personTenantService) {
        this._personTenantService = personTenantService;
    }

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        Set<ProfileId> profileIds = this.filterItemsByType(parentIds, ProfileId.class);
        this.handleDeletedProfiles(profileIds, deletionContext);
    }

    private void handleDeletedProfiles(Set<ProfileId> profileIds, DeletionContext deletionContext) {
        Set<PersonId> personIds = profileIds.stream().map(ProfileId::asPersonId).collect(Collectors.toSet());
        personIds.forEach(personId -> this._personTenantService.deletePersonTenantsForPerson((PersonId)personId, deletionContext));
    }

    protected <T extends ItemId> Set<T> filterItemsByType(Set<? extends ItemId> itemIds, Class<T> type) {
        return itemIds.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
    }
}

