/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.business.settings.Setting;
import de.justsoftware.onx.person.integration.persistence.PersonSettingsDao;
import de.justsoftware.onx.person.model.DBHomeScreenEntry;
import de.justsoftware.onx.person.shared.model.settings.PersonSettings;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
@ParametersAreNonnullByDefault
public class PersonSettingServiceImpl
implements PersonSettingService {
    public static final int MAX_HOME_SCREEN_PAGES = 10;
    private static final Logger LOG = LoggerFactory.getLogger(PersonSettingServiceImpl.class);
    private final PersonSettingsDao _dao;
    private final PersonRoleService _personRoleService;
    private final Clock _clock;
    private final TransactionHelper _transactionHelper;
    private final Settings _settings;

    @Autowired
    public PersonSettingServiceImpl(PersonSettingsDao personSettingsDao, PersonRoleService personRoleService, Clock clock, TransactionHelper transactionHelper, Settings settings) {
        this._dao = personSettingsDao;
        this._personRoleService = personRoleService;
        this._clock = clock;
        this._transactionHelper = transactionHelper;
        this._settings = settings;
    }

    @CheckForNull
    private <T> T getSettingValue(Setting<T> type, Map<String, String> settings) {
        return type.convertFromDB(settings.get(type.getDBKey()));
    }

    @Nonnull
    private <T> T getSettingValueOrDefault(Map<String, String> settings, Setting<T> type, T defaultValue) {
        T result = this.getSettingValue(type, settings);
        return result == null ? defaultValue : result;
    }

    private <T> void saveSettingValue(PersonId id, Setting<T> type, @Nullable T value) {
        assert (id != null) : "Expected the given id not to be null!";
        LOG.debug("Preparing to store: [{} = {}] for " + id, (Object)type.getDBKey(), value);
        this.setRawSetting(id, type.getDBKey(), type.convertToDB(value));
    }

    private <T> void deleteSetting(PersonId id, Setting<T> type) {
        if (id != null) {
            this._dao.deleteSettingForPerson(id, type.getDBKey());
        }
    }

    @Override
    public void deleteDependentSettings(Set<PersonId> personIds) {
        this._dao.deleteSettingsForPersons(personIds);
    }

    @Override
    public ImmutableMap<String, String> getRawSettings(PersonId id) {
        return id != null ? this._dao.getPersonSettings(id) : ImmutableMap.of();
    }

    private void checkSettingsKey(@Nullable String key, @Nullable String value) {
        if (!Setting.KEYS.contains((Object)key)) {
            throw new IllegalArgumentException("Can't to set unknown settings key: '" + key + "' to '" + value + "'");
        }
    }

    @Override
    public void setRawSetting(PersonId id, String key, String value) {
        this.checkSettingsKey(key, value);
        if (value != null) {
            this._dao.storePersonSetting(id, key, value);
        } else {
            this._dao.deleteSettingForPerson(id, key);
        }
    }

    @Override
    public ImmutableMap<String, String> setRawSettings(PersonId id, ImmutableMap<String, String> settings) {
        ImmutableMap<String, String> currentSettings = this.getRawSettings(id);
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Map.Entry keyValue : settings.entrySet()) {
            String key = (String)keyValue.getKey();
            String submittedValue = (String)keyValue.getValue();
            this.checkSettingsKey(key, submittedValue);
            if (submittedValue == null || Objects.equal((Object)submittedValue, (Object)currentSettings.get((Object)key))) continue;
            builder.put((Object)id, (Object)key, (Object)submittedValue);
        }
        this._dao.storePersonSettings((ImmutableTable<PersonId, String, String>)builder.build());
        return this.getRawSettings(id);
    }

    @Override
    public PersonSettings getSettings(PersonId id) {
        ImmutableMap<String, String> settings = this.getRawSettings(id);
        PersonSettings result = new PersonSettings();
        result.setAcceptedProfileImageLegalTerms(Boolean.TRUE.equals(this.getSettingValueOrDefault((Map<String, String>)settings, Setting.ACCEPTED_IMAGE_LEGAL_TERMS, (Object)Boolean.FALSE)));
        String roleToViewMultiWiki = this.getSettingValue(Setting.ROLE_TO_VIEW_MULTI_WIKI, (Map<String, String>)settings);
        String validatedRoleName = this.getValidatedRoleToViewMultiWiki(id, roleToViewMultiWiki);
        result.setRoleToViewMultiWiki(validatedRoleName);
        result.setDefaultSearchFilter(this.getSettingValue(Setting.DEFAULT_SEARCH_FILTER, (Map<String, String>)settings));
        return result;
    }

    @Override
    public void setAcceptedProfileImageLegalTerms(PersonId id, boolean accepted) {
        this.saveSettingValue(id, Setting.ACCEPTED_IMAGE_LEGAL_TERMS, accepted);
    }

    @Override
    public void setMultiWikiDefaultViewRole(PersonId id, String roleName) {
        if (roleName != null) {
            this.saveSettingValue(id, Setting.ROLE_TO_VIEW_MULTI_WIKI, roleName);
        } else {
            this.deleteSetting(id, Setting.ROLE_TO_VIEW_MULTI_WIKI);
        }
    }

    @CheckForNull
    private String getValidatedRoleToViewMultiWiki(@Nullable PersonId personId, @Nullable String roleName) {
        if (personId == null) {
            return null;
        }
        if (roleName == null) {
            return null;
        }
        ImmutableSet allPersonAndStaticRoles = this._personRoleService.getAllPersonAndStaticRoles().keySet();
        if (!allPersonAndStaticRoles.contains((Object)roleName)) {
            this.deleteSetting(personId, Setting.ROLE_TO_VIEW_MULTI_WIKI);
            return null;
        }
        return roleName;
    }

    @Override
    public PersonSettings setDefaultSearchFilterForPerson(PersonId id, SearchTextBoxFilterId filterId) {
        this.saveSettingValue(id, Setting.DEFAULT_SEARCH_FILTER, filterId);
        return this.getSettings(id);
    }

    @Override
    public ImmutableList<ImmutableList<AppId>> getHomeScreenApps(PersonId personId) {
        Map<Integer, List<DBHomeScreenEntry>> homeScreenEntriesByPage = this._dao.getHomeScreenEntries(personId).stream().collect(Collectors.groupingBy(DBHomeScreenEntry::getPageNumber));
        ArrayList<ImmutableList> homeScreenApps = new ArrayList<ImmutableList>();
        for (int i = 0; i < 10; ++i) {
            ImmutableList page = (ImmutableList)homeScreenEntriesByPage.getOrDefault(i, (List<DBHomeScreenEntry>)ImmutableList.of()).stream().map(DBHomeScreenEntry::getAppId).collect(ImmutableList.toImmutableList());
            homeScreenApps.add(page);
        }
        return ImmutableList.copyOf(homeScreenApps);
    }

    @Override
    public void deleteHomeScreenApps(PersonId personId) {
        this._dao.deleteHomeScreenEntries(personId);
    }

    @Override
    public void setHomeScreenApps(final PersonId personId, ImmutableList<ImmutableList<AppId>> homeScreenApps) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (int page = 0; page < homeScreenApps.size(); ++page) {
            ImmutableList currentPage = (ImmutableList)homeScreenApps.get(page);
            for (int i = 0; i < currentPage.size(); ++i) {
                builder.add((Object)new DBHomeScreenEntry(personId, (AppId)currentPage.get(i), page, i, this._clock.now()));
            }
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                PersonSettingServiceImpl.this._dao.deleteHomeScreenEntries(personId);
                PersonSettingServiceImpl.this._dao.insertHomeScreenEntries((ImmutableList<DBHomeScreenEntry>)builder.build());
            }
        });
    }

    @Override
    public boolean getPowerBarSetting(PersonId personId) {
        return this.getSettingValueOrDefault((Map<String, String>)this.getRawSettings(personId), Setting.POWER_BAR, this._settings.defaultPowerBarOption());
    }

    @Override
    public void setPowerBarSetting(boolean usage, PersonId personId) {
        this.saveSettingValue(personId, Setting.POWER_BAR, usage);
    }
}

