/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.base.Supplier;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.person.business.PersonExternalIdPublisher;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class PersonExternalIdPublisherImpl
implements PersonExternalIdPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(PersonExternalIdPublisherImpl.class);
    private static final String TOPIC_NAME = "just.persons.externalId";
    private static final Callback LOG_ERROR_CALLBACK = (metadata, exception) -> {
        if (exception != null) {
            LOG.error("Could not publish PersonDataChangedEvent", (Throwable)exception);
        }
    };
    private final KafkaCleaningProducer<String, String> _producer;
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final String _externalIdField;
    private final Supplier<TenantId> _tenantIdSupplier;

    @Autowired
    public PersonExternalIdPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer, @Nullable @Value(value="${externalId:}") String externalIdField, PersonImportMappingDAO personImportMappingDAO, @Qualifier(value="importTenantIdSupplier") Supplier<TenantId> importTenantIdSupplier) {
        this._producer = producer;
        this._personImportMappingDAO = personImportMappingDAO;
        this._externalIdField = externalIdField;
        this._tenantIdSupplier = importTenantIdSupplier;
    }

    @Override
    public void publishMapping(PersonId personId, String externalId) {
        if (this._producer == null) {
            return;
        }
        String[] strings = externalId.split("@", 2);
        JSONObject json = new JSONObject();
        try {
            json.put("externalId", (Object)strings[0]);
            if (strings.length > 1) {
                json.put("domain", (Object)strings[1]);
            }
            if (!StringUtils.isEmpty((String)this._externalIdField)) {
                json.put("fieldId", (Object)this._externalIdField);
            }
            json.put("tenantId", (Object)((TenantId)this._tenantIdSupplier.get()).asString());
            this._producer.send(new ProducerRecord(TOPIC_NAME, (Object)personId.toString(), (Object)json.toString()), LOG_ERROR_CALLBACK);
        }
        catch (JSONException e) {
            LOG.error("Could not publish externalId mapping", (Throwable)e);
            return;
        }
    }

    @Override
    public void deleteMapping(PersonId personId) {
        if (this._producer == null) {
            return;
        }
        this._producer.send(new ProducerRecord(TOPIC_NAME, (Object)personId.toString(), null), LOG_ERROR_CALLBACK);
    }

    @Override
    public void publishAllMappings() {
        if (this._producer == null) {
            return;
        }
        Map<String, PersonId> mappings = this._personImportMappingDAO.getAllMappings();
        KafkaCleaningProducerState producerState = this._producer.beginRefill(new String[]{TOPIC_NAME});
        for (Map.Entry<String, PersonId> entry : mappings.entrySet()) {
            this.publishMapping(entry.getValue(), entry.getKey());
        }
        producerState.finishRefill();
    }

    @Override
    public boolean ready() {
        return this._producer != null;
    }
}

