/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.business.PersonDataDeletionHandler;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.profile.business.ProfileWriteDataService;
import de.justsoftware.onx.push.business.PushNotificationService;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonDataDeletionHandlerImpl
implements PersonDataDeletionHandler {
    @Autowired
    private PersonSettingService _personSettingService;
    @Autowired
    private PushNotificationService _pushNotificationService;
    @Autowired
    private ProfileWriteDataService _profileWriteDataService;
    @Autowired
    private WorkstreamDataService _workstreamDataService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        Iterable profileIds = Iterables.filter(parentIds, ProfileId.class);
        if (!CollectionUtil.isEmpty(profileIds)) {
            ImmutableSet personIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)profileIds, ProfileId.TO_PERSON_ID));
            this._personSettingService.deleteDependentSettings((Set<PersonId>)personIds);
            this._pushNotificationService.removePushTargetAppsOfPersonIds((Set<PersonId>)personIds);
            this._workstreamDataService.deletePinnedHideDatesByPersons((Set<PersonId>)personIds);
            this._profileWriteDataService.deleteProfileAttributesByProfileIds((ImmutableSet<ProfileId>)ImmutableSet.copyOf((Iterable)profileIds));
        }
    }
}

