/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.events.PersonActivatedEvent;
import de.justsoftware.onx.events.PersonBlockedStatusChangedEvent;
import de.justsoftware.onx.events.PersonDeactivatedEvent;
import de.justsoftware.onx.events.PersonDeletedEvent;
import de.justsoftware.onx.person.business.PersonChangesPublisher;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.events.PersonDataChangedEventByImport;
import de.justsoftware.onx.person.business.events.PersonDataChangedEventByUser;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
@ParametersAreNonnullByDefault
public class PersonChangesPublisherImpl
implements ServerEventHandler,
PersonChangesPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(PersonChangesPublisherImpl.class);
    private static final String TOPIC_NAME = "just.persons";
    private static final Callback LOG_ERROR_CALLBACK = (metadata, exception) -> {
        if (exception != null) {
            LOG.error("Could not publish PersonDataChangedEvent", (Throwable)exception);
        }
    };
    private final Producer<String, String> _producer;
    private final PersonDAO _personDAO;
    private final InternalLinkService _internalLinkService;
    private final PersonService _personService;
    private final PermissionItemProducer _permissionItemProducer;

    @Autowired
    public PersonChangesPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, PersonDAO personDAO, InternalLinkService internalLinkService, PersonService personService, PermissionItemProducer permissionItemProducer) {
        this._producer = producer;
        this._personDAO = personDAO;
        this._internalLinkService = internalLinkService;
        this._personService = personService;
        this._permissionItemProducer = permissionItemProducer;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonBlockedOrUnblocked(PersonBlockedStatusChangedEvent event) {
        this.sendPersonData(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonActivated(PersonActivatedEvent event) {
        this.sendPersonData(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeactivated(PersonDeactivatedEvent event) {
        this.sendPersonData(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonChangedByUser(PersonDataChangedEventByUser event) {
        this.sendPersonData(event.getNewData());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonChangedByImport(PersonDataChangedEventByImport event) {
        this.sendPersonData(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeleted(PersonDeletedEvent event) {
        if (this._producer == null) {
            return;
        }
        DBPerson person = this._personService.getPersonById(event.getPersonId());
        if (person != null) {
            this.sendPersonData(person);
            this.publishDeletedPersonToPermission(person.getId());
        }
    }

    private void sendPersonData(DBPerson person) {
        if (this._producer == null) {
            return;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("id", (Object)person.getId().toString());
            json.put("fullName", (Object)person.getFullName());
            json.put("email", (Object)person.getEmail());
            json.put("firstName", (Object)person.getFirstName());
            json.put("lastName", (Object)person.getLastName());
            json.put("title", (Object)person.getTitle());
            json.put("additionalTitle", (Object)person.getAdditionalTitle());
            json.put("deleted", person.isDeleted());
            json.put("active", person.isActive());
            json.put("blocked", person.isBlocked());
            json.put("imageUrl", (Object)ImageUrlUtil.appendServer(ImageUrlUtil.getImagePath(ImageSize.ORIGINAL, ImageType.USER_IMAGE) + ImageUrlUtil.imageOrDefault(person.getImage())));
            json.put("profileHash", (Object)this._internalLinkService.getProfileUrl(person, InternalLinkService.LinkType.PATH));
            this._producer.send(new ProducerRecord(TOPIC_NAME, (Object)person.getId().toString(), (Object)json.toString()), LOG_ERROR_CALLBACK);
        }
        catch (JSONException e) {
            LOG.error("Could not publish PersonDataChangedEvent", (Throwable)e);
            return;
        }
    }

    private void sendPersonData(PersonId personId) {
        if (this._producer == null) {
            return;
        }
        DBPerson person = this._personService.getPersonById(personId);
        if (person != null) {
            this.sendPersonData(person);
            this.publishPersonToPermission(personId, person.isActive());
        }
    }

    @Override
    public void publishAllPersons() {
        StopWatch watch = new StopWatch("publish all persons");
        watch.start("publishing persons to kafka");
        int count = this._personDAO.forAllPersons(this::sendPersonData);
        this.republishAllPersonsToPermission();
        watch.stop();
        LOG.debug("finished processing " + count + " persons.");
        LOG.debug(watch.prettyPrint());
    }

    @Override
    public boolean ready() {
        return this._producer != null;
    }

    private void publishPersonToPermission(PersonId personId, boolean active) {
        this._permissionItemProducer.publishItem(personId.asProfileId().asString(), Optional.empty(), new String[]{active ? null : "DEACTIVATED"});
    }

    private void publishDeletedPersonToPermission(PersonId personId) {
        this._permissionItemProducer.publishDeletedItem(personId.asProfileId().asString());
    }

    private void republishAllPersonsToPermission() {
        this._permissionItemProducer.republish(ItemType.PROFILE.name(), () -> this._personDAO.forAllPersons(person -> this.publishPersonToPermission(person.getId(), person.isActive())));
    }
}

