/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PasswordResetRequestService;
import de.justsoftware.onx.person.integration.persistence.PasswordResetRequestDAO;
import de.justsoftware.onx.person.shared.model.PasswordResetRequest;
import de.justsoftware.onx.person.shared.model.PendingPasswordReset;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PasswordResetRequestServiceImpl
implements PasswordResetRequestService {
    final PasswordResetRequestDAO _resetRequestDAO;
    final Clock _clock;

    @Autowired
    public PasswordResetRequestServiceImpl(PasswordResetRequestDAO resetRequestDAO, @Qualifier(value="javaTimeClock") Clock clock) {
        this._resetRequestDAO = resetRequestDAO;
        this._clock = clock;
    }

    @Override
    public PendingPasswordReset registerPasswordResetRequest(PasswordResetRequest resetRequest) {
        return this._resetRequestDAO.upsertRequestForPerson(resetRequest.getPersonId(), resetRequest.getRequestExpiryTime());
    }

    @Override
    public Optional<PendingPasswordReset> getValidPendingRequest(PersonId personId) {
        LocalDateTime now = LocalDateTime.now(this._clock);
        return this._resetRequestDAO.getPendingRequestForPerson(personId).flatMap(pendingAttempt -> now.isAfter(pendingAttempt.getRequestExpiryTime()) ? Optional.empty() : Optional.of(pendingAttempt));
    }

    @Override
    public void deletePendingRequest(PersonId personId) {
        this._resetRequestDAO.deletePendingRequestForPerson(personId);
    }
}

