/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PasswordResetCodeGenerator;
import de.justsoftware.onx.person.shared.model.PasswordResetRequest;
import de.justsoftware.onx.secret.business.HMacSecretKey;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.SecretService;
import de.justsoftware.onx.util.server.Base64Util;
import de.justsoftware.onx.util.server.HMacUtil;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class PasswordResetCodeGeneratorImpl
implements PasswordResetCodeGenerator {
    private final SecretService _secretService;

    @Autowired
    public PasswordResetCodeGeneratorImpl(SecretService secretService) {
        this._secretService = secretService;
    }

    static long localDateTimeToMillis(LocalDateTime now) {
        return Instant.from(now.atZone(ZoneId.systemDefault())).toEpochMilli();
    }

    @Override
    public PasswordResetRequest generatePasswordResetRequest(PersonId personId, LocalDateTime requestExpiryDate) {
        String verificationCode = this.createAuthenticatedResetCode(requestExpiryDate, personId);
        String resetPasswordPath = "/newPassword/" + verificationCode;
        return new PasswordResetRequest(resetPasswordPath, personId, requestExpiryDate);
    }

    @Override
    public String createAuthenticatedResetCode(LocalDateTime expirationDate, PersonId id) {
        HMacSecretKey secret = (HMacSecretKey)this._secretService.getSecretKey(SecretKeyName.RESET_PASSWORD_SECRET);
        byte[] resetCodeData = ByteBuffer.allocate(16).putLong(PasswordResetCodeGeneratorImpl.localDateTimeToMillis(expirationDate)).putLong(id.getId()).array();
        return Base64Util.encode(HMacUtil.appendHMac(resetCodeData, secret));
    }
}

