/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.LoginValidator;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.LoginException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginValidatorImpl
implements LoginValidator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginValidatorImpl.class);
    private final PersonService _personService;

    @Autowired
    public LoginValidatorImpl(@Nonnull PersonService personService) {
        this._personService = personService;
    }

    @Override
    public DBPerson checkPersonForLogin(DBPerson person) throws LoginException {
        if (person == null || person.isDeleted()) {
            LOG.info("person is null or deleted - throwing BAD_PASSWORD_OR_USERNAME-Error");
            throw new LoginException(LoginException.LoginErrorCode.BAD_PASSWORD_OR_USERNAME);
        }
        if (!person.isActive()) {
            LOG.info("person " + person.getId() + " is inactive");
            throw new LoginException(LoginException.LoginErrorCode.ACCOUNT_NOT_ACTIVE);
        }
        if (person.isBlocked()) {
            LOG.info("person " + person.getId() + " is blocked");
            throw new LoginException(LoginException.LoginErrorCode.ACCOUNT_BLOCKED);
        }
        return person;
    }

    @Override
    public DBPerson checkPersonForLogin(PersonId userId) throws LoginException {
        if (userId == null) {
            LOG.info("person is null - throwing BAD_PASSWORD_OR_USERNAME-Error");
            throw new LoginException(LoginException.LoginErrorCode.BAD_PASSWORD_OR_USERNAME);
        }
        return this.checkPersonForLogin(this._personService.getPersonById(userId));
    }
}

