/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.JustRolesKafkaProducer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class JustRolesKafkaProducerImpl
implements JustRolesKafkaProducer {
    private static final String TOPIC_JUST_ROLES = "just.roles";
    private static final Callback LOG_ERROR_CALLBACK = new Callback(){

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                LOG.error("Could not publish role change event", (Throwable)exception);
            }
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(JustRolesKafkaProducerImpl.class);
    @CheckForNull
    private final KafkaCleaningProducer<String, String> _producer;

    @Autowired
    public JustRolesKafkaProducerImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer) {
        this._producer = producer;
    }

    private void send(String key, @Nullable String msg) {
        if (this._producer != null) {
            this._producer.send(new ProducerRecord(TOPIC_JUST_ROLES, (Object)key, (Object)msg), LOG_ERROR_CALLBACK);
        }
    }

    @Nonnull
    private final String generateKey(PersonId personId, String roleName) {
        return personId.getId() + "@" + roleName;
    }

    @Override
    public void publishRole(PersonId personId, String roleName, boolean added) {
        this.send(this.generateKey(personId, roleName), added ? "t" : null);
    }

    @Override
    public KafkaCleaningProducerState<String> beginRefill() {
        if (this._producer == null) {
            return null;
        }
        return this._producer.beginRefill(new String[]{TOPIC_JUST_ROLES});
    }
}

