/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.attributes.i18n;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Translation {
    public static final Function<Translation, String> TO_KEY = new NullPermeableFunction<Translation, String>(){

        @Override
        protected String applySafe(Translation input) {
            return input.getKey();
        }
    };
    private final Language _language;
    private final String _key;
    private final String _value;

    public Translation(Language language, String key, String value) {
        this._language = language;
        this._key = key;
        this._value = value;
    }

    @Nonnull
    public final Language getLanguage() {
        return this._language;
    }

    @Nonnull
    public final String getKey() {
        return this._key;
    }

    @Nonnull
    public final String getValue() {
        return this._value;
    }

    @Nonnull
    public static Predicate<Translation> isOfLanguage(final Language language) {
        return new NullIsFalsePredicate<Translation>(){

            @Override
            protected boolean applySafe(Translation input) {
                return language.equals(input.getLanguage());
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("language", (Object)this._language).add("key", (Object)this._key).add("value", (Object)this._value).toString();
    }
}

