/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.attributes.i18n;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.person.business.attributes.i18n.I18NString;
import de.justsoftware.onx.person.business.attributes.i18n.NotTranslatedI18NString;
import de.justsoftware.onx.person.business.attributes.i18n.TranslatedI18NString;
import de.justsoftware.onx.person.business.attributes.i18n.Translation;
import de.justsoftware.onx.person.business.attributes.i18n.Translations;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MultiLangBook {
    private static final Function<Translation, String> BY_TERM_FUNC = input -> input != null ? input.getKey() : null;
    private static final Maps.EntryTransformer<String, Collection<Translation>, I18NString> TO_I18N_STRING = (term, translations) -> term != null && translations != null ? new TranslatedI18NString((String)term, (Collection<Translation>)translations) : null;
    private final ImmutableMap<String, I18NString> _i18ns;

    public MultiLangBook(Collection<Translations> manyTranslations) {
        LinkedList<Translation> allTranslations = new LinkedList<Translation>();
        for (Translations ts : manyTranslations) {
            allTranslations.addAll(ts.getTranslations());
        }
        ImmutableListMultimap translationsByTerm = Multimaps.index(allTranslations, BY_TERM_FUNC);
        this._i18ns = ImmutableMap.copyOf((Map)Maps.transformEntries((Map)translationsByTerm.asMap(), TO_I18N_STRING));
    }

    @Nonnull
    public I18NString getI18n(@Nullable String term) {
        I18NString i18nString = (I18NString)this._i18ns.get((Object)term);
        if (i18nString != null) {
            return i18nString;
        }
        return new NotTranslatedI18NString(term);
    }

    @Nonnull
    public Set<String> getAllTerms() {
        return this._i18ns.keySet();
    }

    public String toString() {
        return "MultiLangBook:" + this._i18ns;
    }
}

