/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.events.PersonRolesChangedEvent;
import de.justsoftware.onx.person.business.JustRolesKafkaProducer;
import de.justsoftware.onx.person.business.PersonRolePublisher;
import de.justsoftware.onx.person.business.events.NewContactEvent;
import de.justsoftware.onx.person.business.events.RemoveContactEvent;
import de.justsoftware.onx.person.integration.persistence.FriendsDAO;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class PersonRolePublisherImpl
implements ServerEventHandler,
PersonRolePublisher {
    private final JustRolesKafkaProducer _personRoleProducer;
    private final PersonDAO _personDAO;
    private final FriendsDAO _friendsDAO;

    @Autowired
    public PersonRolePublisherImpl(JustRolesKafkaProducer personPublisher, PersonDAO personDAO, FriendsDAO friendsDAO) {
        this._personRoleProducer = personPublisher;
        this._personDAO = personDAO;
        this._friendsDAO = friendsDAO;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onPersonRolesChangedEvent(PersonRolesChangedEvent event) {
        PersonId personId = event.getPersonId();
        ImmutableSet<PersonRole> newRoles = event.getNewRoles();
        ImmutableSet<PersonRole> oldRoles = event.getOldRoles();
        Sets.SetView rolesAdded = Sets.difference(newRoles, oldRoles);
        Sets.SetView rolesRemoved = Sets.difference(oldRoles, newRoles);
        for (PersonRole role : rolesRemoved) {
            this._personRoleProducer.publishRole(personId, role.getName(), false);
        }
        for (PersonRole role : rolesAdded) {
            this._personRoleProducer.publishRole(personId, role.getName(), true);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewContact(NewContactEvent event) {
        this.publishFriendShipBidirectional(event.getAcceptorId(), event.getRequesterId(), true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRemoveContact(RemoveContactEvent event) {
        this.publishFriendShipBidirectional(event.getFriendId(), event.getPersonId(), false);
    }

    private void publishFriendShipBidirectional(PersonId person1, PersonId person2, boolean added) {
        this.publishFriendShipUni(person1, person2, added);
        this.publishFriendShipUni(person2, person1, added);
    }

    private void publishFriendShipUni(PersonId person1, PersonId person2, boolean added) {
        this._personRoleProducer.publishRole(person1, "PERSON_FRIEND," + person2.getId(), added);
    }

    @Override
    public int publishAllRoles() {
        return this._personDAO.forAllPersonRoles((personId, roleName) -> this._personRoleProducer.publishRole((PersonId)personId, roleName.getName(), true));
    }

    @Override
    public int publishAllFriendships() {
        return this._friendsDAO.forAllFriendships((personId1, personId2) -> this.publishFriendShipUni((PersonId)personId1, (PersonId)personId2, true));
    }
}

