/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.integration.persistence.ibatis;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.notifications.business.NotificationAttribute;
import de.justsoftware.onx.notifications.business.model.IBaseNotification;
import de.justsoftware.onx.notifications.integration.persistence.DBNotificationAttribute;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import de.justsoftware.onx.notifications.shared.model.NotificationStateType;
import de.justsoftware.onx.notifications.shared.model.NotificationType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBNotification
implements IBaseNotification {
    private NotificationId _id;
    private NotificationType _type;
    private NotificationStateType _state;
    private PersonId _originatorId;
    private PersonId _receiverId;
    private EntityId _entityId;
    private EntityType _entityType;
    private ItemId _subjectId;
    private Date _createDate;
    private Date _modifyDate;
    private ArrayList<DBNotificationAttribute> _attributeList = Lists.newArrayList();

    @Override
    public NotificationId getId() {
        return this._id;
    }

    public void setId(@Nonnull NotificationId notificationId) {
        this._id = notificationId;
    }

    @Override
    public NotificationType getType() {
        return this._type;
    }

    public void setType(@Nonnull NotificationType type) {
        this._type = type;
    }

    @Override
    public NotificationStateType getState() {
        return this._state;
    }

    public void setState(@Nonnull NotificationStateType state) {
        this._state = state;
    }

    @Override
    public PersonId getOriginatorId() {
        return this._originatorId;
    }

    public void setOriginatorId(@Nonnull PersonId originatorId) {
        this._originatorId = originatorId;
    }

    @Override
    public PersonId getReceiverId() {
        return this._receiverId;
    }

    public void setReceiverId(@Nonnull PersonId receiverId) {
        this._receiverId = receiverId;
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    public void setEntityId(@Nullable EntityId entityId) {
        this._entityId = entityId;
    }

    @Override
    public EntityType getEntityType() {
        return this._entityType;
    }

    public void setEntityType(@Nullable EntityType entityType) {
        this._entityType = entityType;
    }

    @Override
    public ItemId getSubjectId() {
        return this._subjectId;
    }

    public void setSubjectId(@Nullable ItemId subjectId) {
        this._subjectId = subjectId;
    }

    @Override
    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    public void setCreateDate(@Nonnull Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    @Override
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public void setModifyDate(@Nonnull Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    @Override
    public ImmutableMap<NotificationAttribute, String> getAttributes() {
        if (this._attributeList.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap attributeMap = ImmutableMap.copyOf((Map)Maps.transformValues((Map)Maps.uniqueIndex(this._attributeList, DBNotificationAttribute.TO_KEY), DBNotificationAttribute.TO_VALUE));
        return attributeMap;
    }

    public void setAttributeList(@Nullable List<DBNotificationAttribute> attributes) {
        if (attributes != null) {
            this._attributeList = Lists.newArrayList(attributes);
        }
    }

    @Nonnull
    public List<DBNotificationAttribute> getAttributeList() {
        return this._attributeList;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("type", (Object)this._type).add("state", (Object)this._state).add("originatorId", (Object)this._originatorId).add("receiverId", (Object)this._receiverId).add("entityId", (Object)this._entityId).add("entityType", (Object)this._entityType).add("subjectId", (Object)this._subjectId).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).add("attributeList", this._attributeList).toString();
    }
}

