/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.business.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.notifications.business.NotificationAttribute;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import de.justsoftware.onx.notifications.shared.model.NotificationStateType;
import de.justsoftware.onx.notifications.shared.model.NotificationType;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface IBaseNotification
extends Identifiable<NotificationId> {
    public static final Function<IBaseNotification, PersonId> GET_RECEIVER = new Function<IBaseNotification, PersonId>(){

        public PersonId apply(IBaseNotification input) {
            return input == null ? null : input.getReceiverId();
        }
    };
    public static final Function<IBaseNotification, NotificationType> GET_TYPE = new Function<IBaseNotification, NotificationType>(){

        public NotificationType apply(IBaseNotification input) {
            return input == null ? null : input.getType();
        }
    };
    public static final Function<IBaseNotification, PersonId> GET_ORIGINATOR_ID = new Function<IBaseNotification, PersonId>(){

        public PersonId apply(IBaseNotification input) {
            return input != null ? input.getOriginatorId() : null;
        }
    };

    @Override
    @Nonnull
    public NotificationId getId();

    @Nonnull
    public PersonId getOriginatorId();

    @Nonnull
    public PersonId getReceiverId();

    @Nonnull
    public NotificationStateType getState();

    @Nonnull
    public NotificationType getType();

    @CheckForNull
    public ItemId getSubjectId();

    @CheckForNull
    public EntityId getEntityId();

    @CheckForNull
    public EntityType getEntityType();

    @Nonnull
    public Date getCreateDate();

    @Nonnull
    public Date getModifyDate();

    @Nonnull
    public ImmutableMap<NotificationAttribute, String> getAttributes();
}

