/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.business.impl;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.EntityLinkUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.EntityMemberInvitationReadDataService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.integration.persistence.EntityRecommendationDAO;
import de.justsoftware.onx.container.server.shared.model.EntityRecommendation;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberInternalInvitation;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.notifications.business.NotificationAttribute;
import de.justsoftware.onx.notifications.business.NotificationDispatcher;
import de.justsoftware.onx.notifications.business.NotificationMigrationService;
import de.justsoftware.onx.notifications.business.NotificationReadWriteDataService;
import de.justsoftware.onx.notifications.business.model.BaseNotification;
import de.justsoftware.onx.notifications.business.model.NotificationMigrationStatus;
import de.justsoftware.onx.notifications.integration.persistence.NotificationDAO;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import de.justsoftware.onx.person.integration.persistence.FriendsDAO;
import de.justsoftware.onx.person.shared.model.PersonIdWithMessage;
import de.justsoftware.onx.tasks.business.TaskListService;
import de.justsoftware.onx.tasks.business.TaskService;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.business.model.TaskListBO;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationMigrationServiceImpl
implements NotificationMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMigrationServiceImpl.class);
    private static final int BATCH_SIZE = 1000;
    private static final int CUT_OFF_TIME_IN_MONTHS = 12;
    private static final long MIGRATION_TIMEOUT_IN_MS = TimeUnit.HOURS.toMillis(24L);
    private static final int DAYS_BEFORE_EXPIRATION_NOTICE = 30;
    private final NotificationDAO _notificationDAO;
    private final NotificationDispatcher _notificationDispatcher;
    private final NotificationProducer _notificationProducer;
    private final EntityMemberInvitationReadDataService _entityMemberInvitationReadDataService;
    private final FriendsDAO _friendsDao;
    private final EntityRecommendationDAO _entityRecommendationDao;
    private final EntityVersionService _entityVersionService;
    private final TaskService _taskService;
    private final TaskListService _taskListService;
    private final NotificationReadWriteDataService _notificationReadWriteDataService;
    private final ScheduledExecutorService _executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("NotificationMigrationServiceImpl-%d").build());

    @Autowired
    public NotificationMigrationServiceImpl(NotificationDAO notificationDao, NotificationDispatcher notificationDispatcher, NotificationProducer notificationProducer, EntityMemberInvitationReadDataService entityMemberInvitationReadDataService, FriendsDAO friendsDao, EntityRecommendationDAO entityRecommendationDao, EntityVersionService entityVersionService, TaskService taskService, TaskListService taskListService, NotificationReadWriteDataService notificationReadWriteDataService) {
        this._notificationDAO = notificationDao;
        this._notificationDispatcher = notificationDispatcher;
        this._notificationProducer = notificationProducer;
        this._entityMemberInvitationReadDataService = entityMemberInvitationReadDataService;
        this._friendsDao = friendsDao;
        this._entityRecommendationDao = entityRecommendationDao;
        this._entityVersionService = entityVersionService;
        this._taskService = taskService;
        this._taskListService = taskListService;
        this._notificationReadWriteDataService = notificationReadWriteDataService;
    }

    @Override
    public void startMigrate() {
        boolean migrationTimedOut;
        NotificationMigrationStatus migrationStatus = this._notificationReadWriteDataService.getNotificationMigrationStatus();
        Date migrationStartDate = migrationStatus.getMigrationStartAt();
        boolean bl = migrationTimedOut = migrationStartDate != null && System.currentTimeMillis() - migrationStartDate.getTime() > MIGRATION_TIMEOUT_IN_MS;
        if (migrationStatus.isRunning() && !migrationTimedOut) {
            LOG.info("Notification migration was triggered, but a notification migration proccess is still running.");
            return;
        }
        this._executorService.execute(() -> {
            try {
                this.migrate(migrationStatus);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to migrate notifications.", (Throwable)e);
            }
        });
    }

    private void migrate(NotificationMigrationStatus migrationStatus) {
        LOG.info("Migration of notifications started.");
        Date startTime = new Date();
        LocalDate since = LocalDate.now().minusMonths(12L);
        NotificationId lastMigratedNotificationId = migrationStatus.getLastMigratedNotificationId();
        this._notificationReadWriteDataService.setNotificationMigrationStatus(new NotificationMigrationStatus(true, lastMigratedNotificationId, startTime));
        int migratedNotificationsCount = 0;
        int processedNotificationCount = 0;
        ImmutableList<BaseNotification> openNotifications = this._notificationDAO.getOpenNotificationsSince(since, lastMigratedNotificationId, 1000);
        int batchCount = openNotifications.size();
        while (openNotifications.size() > 0) {
            LOG.info("Started to migrate batch of " + batchCount + " open notifications.");
            processedNotificationCount += batchCount;
            for (BaseNotification oldNotification : openNotifications) {
                Notification convertedNotification = null;
                try {
                    convertedNotification = this.convertToNotification(oldNotification);
                }
                catch (RuntimeException e) {
                    LOG.error("Failed to convert notification " + oldNotification.getId(), (Throwable)e);
                }
                if (convertedNotification != null) {
                    this._notificationProducer.dispatchNotification(convertedNotification);
                    ++migratedNotificationsCount;
                }
                lastMigratedNotificationId = oldNotification.getId();
                this._notificationReadWriteDataService.setNotificationMigrationStatus(new NotificationMigrationStatus(true, lastMigratedNotificationId, startTime));
            }
            LOG.info("Migrate batch of " + batchCount + " open notifications finished.\nTotal migrated notifications: " + processedNotificationCount + "\nTotal skipped notifications: " + (processedNotificationCount - migratedNotificationsCount));
            openNotifications = this._notificationDAO.getOpenNotificationsSince(since, lastMigratedNotificationId, 1000);
        }
        this._notificationReadWriteDataService.setNotificationMigrationStatus(new NotificationMigrationStatus(false, lastMigratedNotificationId, startTime));
        LOG.info("Migration of " + processedNotificationCount + " open notifications finished.\nMigrated notifications: " + migratedNotificationsCount + "\nSkipped notifications: " + (processedNotificationCount - migratedNotificationsCount) + "\nMigration tooks " + (System.currentTimeMillis() - startTime.getTime()) + " ms");
    }

    @CheckForNull
    private Notification convertToNotification(BaseNotification oldNotification) {
        Notification notification = this.generateNotification(oldNotification);
        return notification != null ? notification.toBuilder().withTimestamp(oldNotification.getCreateDate().toInstant()).withWithoutPush(Boolean.TRUE).build() : null;
    }

    @CheckForNull
    private Notification generateNotification(BaseNotification oldNotification) {
        switch (oldNotification.getType()) {
            case ADDED_TO_SHARE: {
                return this.generateAddedToShareNotification(oldNotification);
            }
            case CONTACT_REQUEST_NOTIFICATION: {
                return this.generateContactRequestNotification(oldNotification);
            }
            case CONTACT_REQUEST_ACCEPTED_NOTIFICATION: {
                return this.generateContactRequestAcceptedNotification(oldNotification);
            }
            case INVITATION_NOTIFICATION: {
                return this.generateInvitationNotification(oldNotification);
            }
            case RECOMMENDATION_NOTIFICATION: {
                return this.generateRecommendationNotification(oldNotification);
            }
            case JOIN_REQUEST_NOTIFICATION: {
                return this.generateJoinRequestNotification(oldNotification);
            }
            case ENTITY_VERSION_RELEASE_REQUEST_NOTIFICATION: {
                return this.generateEntityVersionReleaseRequestNotification(oldNotification);
            }
            case ENTITY_VERSION_RELEASE_ACCEPTED_NOTIFICATION: {
                return this.generateEntityVersionReleaseAcceptedNotification(oldNotification);
            }
            case ENTITY_VERSION_RELEASE_DENIED_NOTIFICATION: {
                return this.generateEntityVersionReleaseDeniedNotification(oldNotification);
            }
            case ENTITY_VERSION_WILL_GET_ARCHIVED: {
                return this.generateEntityVersionWillGetArchivedNotification(oldNotification);
            }
            case REMOVED_FROM_CONVERSATION: {
                return this.generateRemovedFromConversationNotification(oldNotification);
            }
            case DELETED_CONVERSATION: {
                return this.generateConversationDeletedNotification(oldNotification);
            }
            case TASK_ASSIGNED: {
                return this.generateTaskAssignedNotification(oldNotification);
            }
            case ADDED_TO_TASK_LIST: {
                return this.generateAddedToTaskListNotification(oldNotification);
            }
            case REQUESTED_SHARE_ACCESS: {
                return this.generateRequestShareAccessNotification(oldNotification);
            }
            case INVITED_USER_REGISTERED: {
                return this.generateInvitedUserRegisteredNotification(oldNotification);
            }
        }
        throw new IllegalStateException("Unsupported notification type " + oldNotification.getType() + " for notification " + oldNotification.getId() + " found.");
    }

    @CheckForNull
    private Notification generateAddedToTaskListNotification(BaseNotification oldNotification) {
        ItemId subjectId = oldNotification.getSubjectId();
        if (!(subjectId instanceof TaskListId)) {
            LOG.warn("Cannot generate old notification with id {} to added to task list notification without a taskListId", (Object)oldNotification.getId());
            return null;
        }
        TaskListId taskListId = (TaskListId)subjectId;
        TaskListBO taskListBO = (TaskListBO)this._taskListService.getTaskLists((Set<TaskListId>)ImmutableSet.of((Object)taskListId)).get((Object)taskListId);
        return this._notificationDispatcher.generateAddedToTaskListNotification(oldNotification.getOriginatorId(), taskListId, taskListBO.getName(), (Set<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()));
    }

    @CheckForNull
    private Notification generateTaskAssignedNotification(BaseNotification oldNotification) {
        EntityId recommendedEntity;
        ItemId subjectId = oldNotification.getSubjectId();
        if (!(subjectId instanceof TaskId)) {
            LOG.warn("Cannot generate old notification with id {} to task assigned notification without a taskId", (Object)oldNotification.getId());
            return null;
        }
        TaskId taskId = (TaskId)subjectId;
        TaskBO taskBO = (TaskBO)this._taskService.getTasks((Set<TaskId>)ImmutableSet.of((Object)taskId)).get((Object)taskId);
        String attachmentUrl = taskBO.getAttachmentUrl();
        EntityId entityId = recommendedEntity = StringUtil.isEmpty(attachmentUrl) ? null : EntityLinkUtil.parseEntityLink(attachmentUrl, TokenUtilServer.INSTANCE);
        if (recommendedEntity == null) {
            return this._notificationDispatcher.generateTaskAssignedNotification(oldNotification.getOriginatorId(), taskId, taskBO.getName(), oldNotification.getReceiverId());
        }
        return this._notificationDispatcher.generateRecommendationTaskAssignedNotification(oldNotification.getOriginatorId(), taskId, taskBO.getName(), oldNotification.getReceiverId(), recommendedEntity);
    }

    @CheckForNull
    private Notification generateConversationDeletedNotification(BaseNotification oldNotification) {
        String conversationTitle = (String)oldNotification.getAttributes().get((Object)NotificationAttribute.CONVERSATION_TITLE);
        if (conversationTitle == null) {
            LOG.warn("Cannot generate old notification with id {} to conversation deleted notification without a conversation title", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateConversationDeletedNotification(oldNotification.getOriginatorId(), (ImmutableSet<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()), conversationTitle);
    }

    @CheckForNull
    private Notification generateRemovedFromConversationNotification(BaseNotification oldNotification) {
        String conversationTitle = (String)oldNotification.getAttributes().get((Object)NotificationAttribute.CONVERSATION_TITLE);
        if (conversationTitle == null) {
            LOG.warn("Cannot generate old notification with id {} to remove from conversation notification without a conversation title", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateRemovedFromConversationNotification(oldNotification.getOriginatorId(), (Set<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()), conversationTitle);
    }

    @CheckForNull
    private Notification generateEntityVersionWillGetArchivedNotification(BaseNotification oldNotification) {
        EntityVersion entityVersion = this.getEntityVersion(oldNotification);
        if (entityVersion == null) {
            LOG.warn("Cannot generate old notification with id {} to entity version will get archived notification without a entityVersion", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityVersionWillGetArchivedNotification(oldNotification.getReceiverId(), entityVersion, 30);
    }

    @CheckForNull
    private Notification generateEntityVersionReleaseDeniedNotification(BaseNotification oldNotification) {
        EntityVersion entityVersion = this.getEntityVersion(oldNotification);
        if (entityVersion == null) {
            LOG.warn("Cannot generate old notification with id {} to entity version release denied notification without a entityVersion", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityVersionDeclinedNotification(oldNotification.getOriginatorId(), entityVersion);
    }

    @CheckForNull
    private Notification generateEntityVersionReleaseAcceptedNotification(BaseNotification oldNotification) {
        EntityVersion entityVersion = this.getEntityVersion(oldNotification);
        if (entityVersion == null) {
            LOG.warn("Cannot generate old notification with id {} to entity version release accepted notification without a entityVersion", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityVersionReleaseRequestAcceptedNotification(entityVersion, oldNotification.getOriginatorId());
    }

    @CheckForNull
    private Notification generateEntityVersionReleaseRequestNotification(BaseNotification oldNotification) {
        EntityVersion entityVersion = this.getEntityVersion(oldNotification);
        if (entityVersion == null) {
            LOG.warn("Cannot generate old notification with id {} to entity version release request notification without a entityVersion", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityVersionReviewRequestNotification(entityVersion, oldNotification.getReceiverId());
    }

    @CheckForNull
    private EntityVersion getEntityVersion(BaseNotification oldNotification) {
        ItemId subjectId = oldNotification.getSubjectId();
        if (!(subjectId instanceof EntityVersionId)) {
            return null;
        }
        return this._entityVersionService.getVersionById((EntityVersionId)subjectId);
    }

    @CheckForNull
    private Notification generateJoinRequestNotification(BaseNotification oldNotification) {
        EntityId entityId = oldNotification.getEntityId();
        if (entityId == null) {
            LOG.warn("Cannot generate old notification with id {} to join request notification without entityId", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityJoinRequestNotification(oldNotification.getOriginatorId(), entityId, (ImmutableSet<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()));
    }

    @CheckForNull
    private Notification generateRecommendationNotification(BaseNotification oldNotification) {
        EntityId entityId = oldNotification.getEntityId();
        if (entityId == null) {
            LOG.warn("Cannot generate old notification with id {} to recommendation notification without entityId", (Object)oldNotification.getId());
            return null;
        }
        EntityRecommendation recommendation = this._entityRecommendationDao.getRecommendationById(entityId, oldNotification.getReceiverId());
        if (recommendation == null) {
            LOG.warn("Cannot generate old notification with id {} to recommendation notification without recommendation", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityRecommendationNotification(oldNotification.getOriginatorId(), oldNotification.getReceiverId(), entityId, recommendation.getRecommendationMessage());
    }

    @CheckForNull
    private Notification generateInvitationNotification(BaseNotification oldNotification) {
        EntityId entityId = oldNotification.getEntityId();
        if (entityId == null) {
            LOG.warn("Cannot generate old notification with id {} to invitation notification without entityId", (Object)oldNotification.getId());
            return null;
        }
        EntityMemberInternalInvitation invitation = this._entityMemberInvitationReadDataService.getInternalInvitationByMemberId(entityId, oldNotification.getReceiverId());
        if (invitation == null) {
            LOG.warn("Cannot generate old notification with id {} to invitation notification without entityId", (Object)oldNotification.getId());
            return null;
        }
        return this._notificationDispatcher.generateEntityInternalInvitationNotification(oldNotification.getOriginatorId(), entityId, (Set<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()), invitation.getInviteMessage());
    }

    @CheckForNull
    private Notification generateContactRequestAcceptedNotification(BaseNotification oldNotification) {
        return this._notificationDispatcher.generateContactRequestAcceptedNotification(oldNotification.getOriginatorId(), oldNotification.getReceiverId());
    }

    @CheckForNull
    private Notification generateContactRequestNotification(BaseNotification oldNotification) {
        List<PersonIdWithMessage> invitations = this._friendsDao.getInvitations(oldNotification.getReceiverId());
        Optional<String> message = invitations.stream().filter(invitation -> invitation.getId().equals(oldNotification.getOriginatorId())).map(PersonIdWithMessage::getMessage).filter((Predicate<String>)Predicates.notNull()).findFirst();
        return this._notificationDispatcher.generateContactRequestNotification(oldNotification.getOriginatorId(), oldNotification.getReceiverId(), message.orElse(null));
    }

    @CheckForNull
    private Notification generateAddedToShareNotification(BaseNotification oldNotification) {
        String shareName = (String)oldNotification.getAttributes().get((Object)NotificationAttribute.SHARE_NAME);
        DriveShareId shareId = new DriveShareId(UUID.fromString((String)oldNotification.getAttributes().get((Object)NotificationAttribute.SHARE_ROOT_FOLDER_ID)));
        return this._notificationDispatcher.generateDriveShareAccessGrantNotification(oldNotification.getReceiverId(), oldNotification.getOriginatorId(), shareName, shareId);
    }

    @CheckForNull
    private Notification generateRequestShareAccessNotification(BaseNotification oldNotification) {
        ImmutableMap<NotificationAttribute, String> attributes = oldNotification.getAttributes();
        ItemId subjectId = oldNotification.getSubjectId();
        String shareName = (String)attributes.get((Object)NotificationAttribute.SHARE_NAME);
        if (shareName == null || !(subjectId instanceof DriveShareId)) {
            return null;
        }
        DriveShareId driveShareId = (DriveShareId)subjectId;
        return this._notificationDispatcher.generateDriveShareAccessRequestNotification(oldNotification.getOriginatorId(), driveShareId, shareName, (Set<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()));
    }

    @CheckForNull
    private Notification generateInvitedUserRegisteredNotification(BaseNotification oldNotification) {
        return this._notificationDispatcher.generateInvitedUserRegisteredNotification(oldNotification.getOriginatorId(), (Set<PersonId>)ImmutableSet.of((Object)oldNotification.getReceiverId()));
    }
}

