/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.business;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.notificationclient.NotificationKafkaProducer;
import de.justsoftware.notificationclient.NotificationProducer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class NotificationConfig {
    private static final long THREADPOOL_KEEP_ALIVE_TIME_MINUTES = 10L;

    @Nonnull
    @Bean
    public NotificationProducer notificationProducer(KafkaCleaningProducer<String, String> kafkaProducer) {
        return new NotificationKafkaProducer(kafkaProducer);
    }

    @Nonnull
    @Bean(name={"notificationDispatcherThreadPool"})
    public ExecutorService notificationDispatcherThreadPool(@Value(value="${toro.notificationDispatcher.maxThreads:5}") int maxThreads) {
        return new ThreadPoolExecutor(0, maxThreads, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    }
}

