/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notificationpush.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.mobilepush.model.PushReceiver;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.notificationpush.business.NotificationPushFactory;
import de.justsoftware.onx.notificationpush.business.impl.ApnsFactoryDelegate;
import de.justsoftware.onx.notificationpush.business.impl.FcmFactoryDelegate;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.push.business.PushNotificationService;
import de.justsoftware.onx.push.model.PushNotifications;
import de.justsoftware.onx.push.shared.model.PushAppName;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import de.justsoftware.onx.push.util.PushTargetApps;
import de.justsoftware.pushnotification.client.model.ApnsPushNotification;
import de.justsoftware.pushnotification.client.model.FcmPushNotification;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NotificationPushFactoryImpl
implements NotificationPushFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationPushFactoryImpl.class);
    private static final ImmutableSet<PushAppName> SUPPORTED_APP_NAMES = ImmutableSet.of((Object)((Object)PushAppName.MOBILE_NG_WRAPPER), (Object)((Object)PushAppName.MOBILE_NG_NATIVE_WRAPPER));
    private final PushNotificationService _pushNotificationService;
    private final PersonService _personService;
    private final Settings _settings;
    private final FcmFactoryDelegate _fcmFactoryDelegate;
    private final ApnsFactoryDelegate _apnsFactoryDelegate;

    @Autowired
    public NotificationPushFactoryImpl(PushNotificationService pushNotificationService, PersonService personService, Settings settings, I18nService i18nService, JucoObjectMapper objectMapper) {
        this._pushNotificationService = pushNotificationService;
        this._personService = personService;
        this._settings = settings;
        this._fcmFactoryDelegate = new FcmFactoryDelegate(i18nService, objectMapper);
        this._apnsFactoryDelegate = new ApnsFactoryDelegate(objectMapper);
    }

    @Override
    public PushNotifications createPushNotifications(PushNotification pushNotification) {
        try {
            return this.internalCreatePushNotifications(pushNotification);
        }
        catch (RuntimeException e) {
            LOG.error("Push message for mobile push notification not created.", (Throwable)e);
            return PushNotifications.EMPTY;
        }
    }

    @Nonnull
    private PushNotifications internalCreatePushNotifications(PushNotification mobilePush) {
        SetMultimap<PersonId, PushTargetApp> pushTargets = this.pushTargetsByUser(mobilePush.getReceivers());
        Map<PersonId, Locale> locales = this.localeByPersonId(pushTargets.keySet());
        Map<PersonId, Integer> unreadCounts = this.unreadCountByPersonId(mobilePush.getReceivers());
        return new PushNotifications(this.apnsPushNotifications(mobilePush, pushTargets, locales, unreadCounts), this.fcmPushNotifications(mobilePush, pushTargets, locales, unreadCounts));
    }

    @Nonnull
    private List<ApnsPushNotification> apnsPushNotifications(PushNotification mobilePush, SetMultimap<PersonId, PushTargetApp> pushTargets, Map<PersonId, Locale> locales, Map<PersonId, Integer> unreadCounts) {
        return pushTargets.entries().stream().filter(entry -> PushTargetApps.isApns((PushTargetApp)entry.getValue())).map(entry -> {
            PersonId personId = (PersonId)entry.getKey();
            PushTargetApp app = (PushTargetApp)entry.getValue();
            return this._apnsFactoryDelegate.pushNotification(mobilePush, app.getPushNotificationApp(), app.getToken(), (Integer)unreadCounts.get(personId), (Locale)locales.get(personId));
        }).collect(Collectors.toList());
    }

    @Nonnull
    private List<FcmPushNotification> fcmPushNotifications(PushNotification mobilePush, SetMultimap<PersonId, PushTargetApp> pushTargets, Map<PersonId, Locale> locales, Map<PersonId, Integer> unreadCounts) {
        return pushTargets.entries().stream().filter(entry -> PushTargetApps.isFcm((PushTargetApp)entry.getValue())).map(entry -> {
            PersonId personId = (PersonId)entry.getKey();
            PushTargetApp app = (PushTargetApp)entry.getValue();
            return this._fcmFactoryDelegate.pushNotification(mobilePush, app.getPushNotificationApp(), app.getToken(), (Integer)unreadCounts.get(personId), (Locale)locales.get(personId));
        }).collect(Collectors.toList());
    }

    @Nonnull
    private SetMultimap<PersonId, PushTargetApp> pushTargetsByUser(Set<PushReceiver> receivers) {
        if (receivers.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        return (SetMultimap)this._pushNotificationService.getPushTargetAppsByPersonIds(NotificationPushFactoryImpl.receiverPersonIds(receivers)).entries().stream().filter(entry -> NotificationPushFactoryImpl.isSupportedApp((PushTargetApp)entry.getValue())).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    private Map<PersonId, Locale> localeByPersonId(Set<PersonId> receivers) {
        if (receivers.isEmpty()) {
            return ImmutableMap.of();
        }
        return (Map)this._personService.getPersonsByIds(receivers).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.localeFor((DBPerson)entry.getValue())));
    }

    @Nonnull
    private Map<PersonId, Integer> unreadCountByPersonId(Set<PushReceiver> receivers) {
        return (Map)receivers.stream().collect(ImmutableMap.toImmutableMap(NotificationPushFactoryImpl::personId, PushReceiver::getUnreadNotifications));
    }

    @Nonnull
    private Locale localeFor(DBPerson person) {
        String language = person.getLanguageId();
        return language != null ? new Locale(language) : new Locale(this._settings.defaultLanguage());
    }

    @Nonnull
    private static Set<PersonId> receiverPersonIds(Set<PushReceiver> receivers) {
        return (Set)receivers.stream().map(NotificationPushFactoryImpl::personId).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private static PersonId personId(PushReceiver receiver) {
        return ProfileId.parseNonnull(receiver.getId()).asPersonId();
    }

    private static boolean isSupportedApp(PushTargetApp app) {
        return SUPPORTED_APP_NAMES.contains((Object)app.getAppName());
    }
}

