/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notificationpush.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.notificationpush.model.NotificationPushDestination;
import de.justsoftware.onx.push.model.PushNotificationType;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
abstract class AbstractFactoryDelegate {
    protected static final PushNotificationType NOTIFICATION_TYPE = PushNotificationType.NEW_NOTIFICATIONS;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFactoryDelegate.class);
    private final JucoObjectMapper _objectMapper;

    protected AbstractFactoryDelegate(JucoObjectMapper objectMapper) {
        this._objectMapper = objectMapper;
    }

    @Nonnull
    protected String title(PushNotification mobilePush, Locale locale) {
        return Strings.nullToEmpty((String)mobilePush.getLocalizedTitle().getOrDefault(locale, mobilePush.getFallbackTitle()));
    }

    @Nonnull
    protected String text(PushNotification mobilePush, Locale locale) {
        return Strings.nullToEmpty((String)mobilePush.getLocalizedText().getOrDefault(locale, mobilePush.getFallbackText()));
    }

    @CheckForNull
    protected String destination(PushNotification mobilePush) {
        NotificationType notificationType = mobilePush.getType();
        if (notificationType == null) {
            return null;
        }
        NotificationPushDestination destination = new NotificationPushDestination(mobilePush.getId(), mobilePush.getAppId(), notificationType, mobilePush.getTargetId());
        try {
            return this._objectMapper.writeValueAsString(destination);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error serializing NotificationPushDestination to JSON", (Throwable)e);
            return null;
        }
    }
}

