/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.ItemId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NewsZoomSectionCreateModel {
    private final String _name;
    private final boolean _showOnlyPinned;
    private final int _order;
    private final ImmutableSet<ItemId> _channelIdsToAdd;

    public NewsZoomSectionCreateModel(String name, boolean showOnlyPinned, int order, ImmutableSet<ItemId> channelIdsToAdd) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Section name must not be empty");
        Preconditions.checkArgument((!channelIdsToAdd.isEmpty() ? 1 : 0) != 0, (Object)"Section must contain at least one channel");
        this._name = name;
        this._showOnlyPinned = showOnlyPinned;
        this._order = order;
        this._channelIdsToAdd = ImmutableSet.copyOf(channelIdsToAdd);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public boolean isShowOnlyPinned() {
        return this._showOnlyPinned;
    }

    public int getOrder() {
        return this._order;
    }

    @Nonnull
    public ImmutableSet<ItemId> getChannelIdsToAdd() {
        return this._channelIdsToAdd;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this._name).add("showOnlyPinned", this._showOnlyPinned).add("order", this._order).add("channelIdsToAdd", this._channelIdsToAdd).toString();
    }
}

