/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.integration.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.newszoom.shared.model.NewsZoomSectionEditModel;
import de.justsoftware.onx.newszoom.shared.model.SectionId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NewsZoomSection {
    private final SectionId _sectionId;
    private final TenantId _tenantId;
    private final String _name;
    private final boolean _showOnlyPinned;
    private final int _order;

    public NewsZoomSection(SectionId sectionId, TenantId tenantId, String name, boolean showOnlyPinned, int order) {
        this._sectionId = sectionId;
        this._tenantId = tenantId;
        this._name = name;
        this._showOnlyPinned = showOnlyPinned;
        this._order = order;
    }

    public NewsZoomSection(TenantId tenantId, NewsZoomSectionEditModel editModel) {
        this._sectionId = editModel.getId();
        this._tenantId = tenantId;
        this._name = editModel.getName();
        this._showOnlyPinned = editModel.isShowOnlyPinned();
        this._order = editModel.getOrder();
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public boolean isShowOnlyPinned() {
        return this._showOnlyPinned;
    }

    public int getOrder() {
        return this._order;
    }

    @Nonnull
    public SectionId getSectionId() {
        return this._sectionId;
    }

    @Nonnull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sectionId", (Object)this._sectionId).add("tenantId", (Object)this._tenantId).add("name", (Object)this._name).add("showOnlyPinned", this._showOnlyPinned).add("order", this._order).toString();
    }
}

