/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.integration.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.newszoom.integration.persistence.NewsZoomSettingsDAO;
import de.justsoftware.onx.newszoom.integration.persistence.mapper.NewsZoomSettingsMapper;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSection;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSectionCreateDAOModel;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSettings;
import de.justsoftware.onx.newszoom.shared.model.NewsZoomSettingsEditModel;
import de.justsoftware.onx.newszoom.shared.model.SectionId;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class NewsZoomSettingsDaoImpl
implements NewsZoomSettingsDAO {
    private final NewsZoomSettingsMapper _mapper;
    private final DAOSupport _daoSupport;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public NewsZoomSettingsDaoImpl(NewsZoomSettingsMapper mapper, DAOSupport daoSupport, TransactionHelper transactionHelper) {
        this._mapper = mapper;
        this._daoSupport = daoSupport;
        this._transactionHelper = transactionHelper;
    }

    @Override
    public NewsZoomSettings getNewsZoomSettings(TenantId tenantId) {
        return this._mapper.getNewsZoomSettings(tenantId);
    }

    @Override
    public ImmutableList<NewsZoomSection> getNewsZoomSections(TenantId tenantId) {
        return ImmutableList.copyOf(this._mapper.getNewsZoomSections(tenantId));
    }

    @Override
    public ImmutableSetMultimap<SectionId, ItemId> getChannelsForSections(Set<SectionId> sectionIds) {
        return this._daoSupport.partition(sectionIds).asSetMultimap(this._mapper::getChannelsForSections);
    }

    @Override
    public void updateNewsZoomSettings(TenantId tenantId, NewsZoomSettingsEditModel settings) {
        this._mapper.updateNewsZoomSettings(tenantId, settings.isCycleAutomatically(), settings.getOpenOn(), settings.getCycleDelayInSeconds());
    }

    @Override
    public void setNewsZoomSectionChannels(SectionId sectionId, Set<ItemId> channelIds) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._mapper.removeChannelsFromSection(sectionId);
            channelIds.forEach(channelId -> this._mapper.addChannelToSection(sectionId, (ItemId)channelId));
        });
    }

    @Override
    public SectionId addNewsZoomSection(TenantId tenantId, NewsZoomSectionCreateDAOModel section) {
        this._mapper.addSection(section.getSectionId(), tenantId, section.getName(), section.isShowOnlyPinned(), section.getOrder());
        return section.getSectionId();
    }

    @Override
    public void deleteNewsZoomSections(Set<SectionId> sectionIds, TenantId tenantId) {
        this._daoSupport.partition(sectionIds).noResult(sectionId -> this._mapper.deleteSections(sectionId, tenantId));
    }

    @Override
    public void updateNewsZoomSection(NewsZoomSection section) {
        this._mapper.updateSection(section.getSectionId(), section.getTenantId(), section.getName(), section.isShowOnlyPinned(), section.getOrder());
    }
}

