/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.comments.shared.model.CommentId;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public class PostCommentKafkaDto {
    private final String _id;
    private final String _authorId;
    private final String _jsonContent;
    private final String _text;
    private final CommentId _commentId;
    private final Instant _postedAt;
    @Nullable
    private final Instant _editedAt;
    @Nullable
    private final String _editorId;

    public PostCommentKafkaDto(String authorId, String jsonContent, String text, CommentId commentId, Instant postedAt, @Nullable Instant editedAt, @Nullable String editorId) {
        this._id = "COMMENT," + UUID.randomUUID();
        this._authorId = authorId;
        this._jsonContent = jsonContent;
        this._text = text;
        this._commentId = commentId;
        this._postedAt = postedAt;
        this._editedAt = editedAt;
        this._editorId = editorId;
    }

    @JsonCreator
    @VisibleForTesting
    public PostCommentKafkaDto(@JsonProperty(value="id") String id, @JsonProperty(value="authorId") String authorId, @JsonProperty(value="jsonContent") String jsonContent, @JsonProperty(value="text") String text, @JsonProperty(value="commentId") CommentId commentId, @JsonProperty(value="postedAt") Instant postedAt, @JsonProperty(value="editedAt") @Nullable Instant editedAt, @JsonProperty(value="editorId") @Nullable String editorId) {
        this._id = id;
        this._authorId = authorId;
        this._jsonContent = jsonContent;
        this._text = text;
        this._commentId = commentId;
        this._postedAt = postedAt;
        this._editedAt = editedAt;
        this._editorId = editorId;
    }

    public JSONObject toJson() {
        return new JSONObject().put("id", (Object)this._id).put("authorId", (Object)this._authorId).put("jsonContent", (Object)this._jsonContent).put("text", (Object)this._text).put("postedAt", this._postedAt.getEpochSecond()).put("editedAt", this._editedAt != null ? Long.valueOf(this._editedAt.getEpochSecond()) : null).put("editorId", (Object)this._editorId);
    }

    public String getId() {
        return this._id;
    }

    public CommentId getCommentId() {
        return this._commentId;
    }

    public String getAuthorId() {
        return this._authorId;
    }

    public String getText() {
        return this._text;
    }

    public String getJsonContent() {
        return this._jsonContent;
    }
}

