/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration.newscover;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.news.migration.NewsMigrationDAO;
import de.justsoftware.onx.news.migration.newscover.NewsCoverKafkaDto;
import de.justsoftware.onx.news.migration.newscover.NewsCoverSectionChannelKafkaDto;
import de.justsoftware.onx.news.migration.newscover.NewsCoverSectionKafkaDto;
import de.justsoftware.onx.news.migration.newscover.NewsZoomSettingsMigration;
import de.justsoftware.onx.newszoom.integration.persistence.NewsZoomSettingsDAO;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSection;
import de.justsoftware.onx.newszoom.shared.model.OpenOn;
import de.justsoftware.onx.newszoom.shared.model.SectionId;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NewsCoverMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(NewsCoverMigrationService.class);
    private static final String NEWS_COVER_SECTION = "NEWS_COVER_SECTION,";
    private static final String TORO_DEFAULT_TITLE = "TEMP-SECTION_DEFAULT-NAME";
    private static final String SNOWBALL_DEFAULT_TITLE = "DEFAULT_TITLE";
    private final Producer<String, String> _producer;
    private final NewsMigrationDAO _newsMigrationDAO;
    private final NewsZoomSettingsDAO _newsZoomSettingsDAO;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public NewsCoverMigrationService(@Nullable @Qualifier(value="KAFKA_LARGE_STRING_PRODUCER") Producer<String, String> producer, NewsMigrationDAO newsMigrationDAO, NewsZoomSettingsDAO newsZoomSettingsDAO, TransactionHelper transactionHelper) {
        this._producer = producer;
        this._newsMigrationDAO = newsMigrationDAO;
        this._newsZoomSettingsDAO = newsZoomSettingsDAO;
        this._transactionHelper = transactionHelper;
    }

    public void migrateNewsCovers() {
        LOG.info("News cover migration started");
        if (this._producer == null) {
            LOG.warn("Abort migrateNewsCovers because _producer is null!");
            return;
        }
        Set<NewsZoomSettingsMigration> newsZoomSettings = this._newsMigrationDAO.getAllNewsZoomSettings();
        for (NewsZoomSettingsMigration newsZoomSetting : newsZoomSettings) {
            this._transactionHelper.doInTransactionWithoutResult(t -> this.migrateNewsCover(newsZoomSetting));
        }
        LOG.info("News cover migration finished. {} news covers migrated", (Object)newsZoomSettings.size());
    }

    private void migrateNewsCover(NewsZoomSettingsMigration newsZoomSettings) {
        ImmutableList<NewsZoomSection> sections = this._newsZoomSettingsDAO.getNewsZoomSections(newsZoomSettings.getTenantId());
        ImmutableSetMultimap<SectionId, ItemId> sectionChannels = this._newsZoomSettingsDAO.getChannelsForSections(sections.stream().map(NewsZoomSection::getSectionId).collect(Collectors.toSet()));
        ImmutableMap<ItemId, ItemId> migratedChannels = this._newsMigrationDAO.getAllMigratedItems("CHANNEL,%");
        Set sectionChannelDtos = sectionChannels.entries().stream().filter(cs -> ((ItemId)cs.getValue()).getType() == ItemType.ENTITY).map(cs -> new NewsCoverSectionChannelKafkaDto(NEWS_COVER_SECTION + cs.getKey(), (NewsChannelId)migratedChannels.get(cs.getValue()))).collect(Collectors.toSet());
        if (sectionChannelDtos.stream().anyMatch(sc -> sc.getChannelId() == null)) {
            LOG.error("Skipping migration. Not all channels for tenant " + newsZoomSettings.getTenantId() + " have been migrated. Please migrate all channels first");
            return;
        }
        Set<NewsCoverSectionKafkaDto> sectionDtos = sections.stream().map(s -> new NewsCoverSectionKafkaDto(NEWS_COVER_SECTION + s.getSectionId(), s.getName().equals(TORO_DEFAULT_TITLE) ? SNOWBALL_DEFAULT_TITLE : s.getName(), s.getOrder(), s.isShowOnlyPinned(), sectionChannelDtos.stream().filter(sc -> sc.getSectionId().equals(NEWS_COVER_SECTION + s.getSectionId())).collect(Collectors.toSet()))).collect(Collectors.toSet());
        NewsCoverKafkaDto newsCoverDto = new NewsCoverKafkaDto(newsZoomSettings.getTenantId().asString(), newsZoomSettings.getOpenOn() == OpenOn.LOGIN, newsZoomSettings.isCycleAutomatically() ? newsZoomSettings.getCycleTimeInSeconds() : 0, sectionDtos);
        this.publishToKafka(newsCoverDto);
    }

    private void publishToKafka(NewsCoverKafkaDto newsCoverKafkaDto) {
        if (this._producer == null) {
            LOG.warn("Abort publishToKafka because _producer is null!");
            return;
        }
        String tenantId = newsCoverKafkaDto.getTenantId();
        this._producer.send(new ProducerRecord("just.toro.migration.news", (Object)tenantId, (Object)newsCoverKafkaDto.toTopicJson()));
    }
}

